/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/validatorcache/URMListener.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.urm.utils.validatorcache;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

/**
 * URMListenerSet.java
 *
 * The CacheListenerSet contains Listeners that have to be triggered if an important
 * event occurs.
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

public class URMListener
{
    protected static URMListener aclListenerSet = null;
    private static final Object listenerSyncObj = new Object();
    private Map listeners = new HashMap();
    
    /**
     * Adds a new listenerElement to ListenerSet
     *
     *
     */
    public synchronized void enlistListenerElement(String key, URMListenerElement listenerElement) {
        listeners.put(key, listenerElement);
    }
    
    /**
     * removes a cache listenerElement from the ListenerSet
     *
     * @param key of the listener that should be removed
     *
     */
    public synchronized void delistListenerElement(String key){
        listeners.remove(key);
    }
    
    /**
     * returns a cached listenerElement from the ListenerSet
     *
     * @param key of the listener that should be returned
     *
     */
    public synchronized URMListenerElement getListenerElement(String key){
        return (URMListenerElement) listeners.get(key);
    }
    
    /**
     * Sends a remove event to all listeners of this ListenerSet
     *
     */
    public synchronized void resetEvent(){
        listeners.clear();
        URMValidatorCache.getCacheForValidator(this).reset();
    }
    
    /**
     * Sends a remove event to all 'key' listeners of this ListenerSet
     *
     * @param key of the event targets
     */
    public synchronized void removeEvent(String key) {
        URMListenerElement listenerElement = (URMListenerElement) listeners.remove(key);
        if (listenerElement != null) listenerElement.remove(this,URMValidatorCache.getCacheForValidator(this));
    }
    
    /******************* URMListerSet methods ******************** start *********/
    /**
     * Returns the AclLisenerSet
     *
     */
    public static URMListener getAclListenerSet() {
        synchronized (listenerSyncObj) {
            if (aclListenerSet == null) aclListenerSet = new URMListener();
        }
        return aclListenerSet;
    }
    
    public static URMListener getAclListenerSet(URMValidatorCache _validatorCache) {
        synchronized (listenerSyncObj) {
            if (aclListenerSet == null) aclListenerSet = new URMListener();
        }
        return aclListenerSet;
    }
}


