/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/validatorcache/URMListenerElement.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.urm.utils.validatorcache;

/**
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

public class URMListenerElement{
    
    private Map resources = new HashMap();

    public void addResource(String uri, URMListenerResource resource) {
        resources.put(uri, resource);
    }
    
    /**
     * removed the listener from the cache
     *
     */
    public void remove(URMListener listeners, URMValidatorCache validatorCache) {
        Iterator resourceKeyIter = resources.keySet().iterator();
        Iterator resourceIter = resources.values().iterator();
        // remove URIs from the validator Cache
        while (resourceKeyIter.hasNext()) validatorCache.remove((String) resourceKeyIter.next());
        while (resourceIter.hasNext()) {
            URMListenerResource resource  = (URMListenerResource) resourceIter.next();
            resource.removeFromElements(listeners);
        }
    }
    
    /**
     * removes that a ResourceElement from this ListenerElement
     *
     */
    public void removeURI(String uri){
        resources.remove(uri);
    }
    
    /**
     * Returns 'true' if no URMResources are enlisted
     *
     * @return 'true' if no URMResources are enlisted
     */
    public boolean isEmpty(){
        return resources.isEmpty();
    }
}

