/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/urm/org/apache/slide/urm/utils/validatorcache/URMListenerResource.java,v 1.4 2005/03/02 10:53:36 eckehard Exp $
 * $Revision: 1.4 $
 * $Date: 2005/03/02 10:53:36 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.urm.utils.validatorcache;
import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/**
 * An instance of this class represents an resource uri for the listener
 *
 * @author eckehard.hermann@softwareag.com
 * @author dieter.kessler@softwareag.com
 * @author zsolt.sasvarie@softwareag.com
 */

public class URMListenerResource
{
    String _uri = null;
    Set aclReferences = new HashSet();
    
    /**
     * Creates a new ListenerResource and add the resource to the AclListener
     */
    public URMListenerResource(String uri, List acls, URMListener listener) {
        _uri = uri;
        Iterator iter = acls.iterator();
        while (iter.hasNext()) {
            String acl = (String)iter.next();
            aclReferences.add(acl);
            URMListenerElement element = listener.getListenerElement(acl);
            if (element == null) {
                element = new URMListenerElement();
                element.addResource(uri, this);
                listener.enlistListenerElement(acl, element);
            } else {
                element.addResource(uri, this);
            }
        }
    }
    
    /**
     * Removes this ListenerResource from the ListenerElements
     *
     * @param    listeners          currentAclListener
     *
     */
    public void removeFromElements(URMListener listeners){
        Iterator aclReferencesIter = aclReferences.iterator();
        while (aclReferencesIter.hasNext()) {
            String acl = (String) aclReferencesIter.next();
            URMListenerElement elem = (URMListenerElement)listeners.getListenerElement(acl);
            if (elem != null) {
                elem.removeURI(_uri);
                if (elem.isEmpty()) listeners.delistListenerElement(acl);
            }
        }
    }
}

