/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/ClassName.java,v 1.3 2004/07/30 06:52:17 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:17 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;


/**
 * Utility class for Java class names.
 *
 * @author    peter.nevermann@softwareag.com
 *
 * @version   $Revision: 1.3 $
 */
public class ClassName {
    
    /**
     * The tokens
     */
    private List tokens = new ArrayList();

    
    /**
     * Default contructor
     *
     * @param      name   the fully qualified class name
     */
    public ClassName( String name ) {
        StringTokenizer st = new StringTokenizer( name, "." );
        
        while( st.hasMoreTokens() ) {
            tokens.add( st.nextToken() );
        }
    }
    
    /**
     * Return the un-qualified name.
     *
     * @return     the plain (un-qualified) class name
     */
    public String getPlainName() {
        if( tokens.isEmpty() ) {
            return null;
        }
        else {
            return (String) tokens.get( tokens.size() - 1 );
        }
    }
}
