/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/Pattern.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util;

/**
 ** @version   $Revision: 1.1 $
 **/

public class Pattern {
    private final String pattern;
    private final String variable;
    private final int variableLength;
    
    public Pattern(String pattern) {
        this(pattern, "${store}");
    }
    
    public Pattern(String pattern, String variable) {
        if (pattern == null) {
            throw new XAssertionFailed();
        }
        if (variable == null) {
            throw new XAssertionFailed();
        }
        this.pattern = pattern;
        this.variable = variable;
        this.variableLength = variable.length();
    }
    
    public boolean equals(Object obj) {
        Pattern p;
        
        if (obj instanceof Pattern) {
            p = (Pattern) obj;
            return pattern.equals(p.pattern) && variable.equals(p.variable);
        } else {
            return false;
        }
    }
    

    public boolean isParameterized() {
        return pattern.indexOf(variable) != -1;
    }
    
    public String resolve(String value) {
        int k;
        StringBuffer b;
        
        b = new StringBuffer(pattern);
        for (k = pattern.indexOf(variable); k != -1; k = b.toString().indexOf(variable)) {
            b.replace( k, k + variableLength, value );
        }
        return b.toString();
    }
    
    public static final String NO_VAR = "";
    
    public String toString() {
        return "Pattern(pattern=" + pattern + ", variable=" + variable +")";
    }
    /**
     * @return store parameter
     */
    public String match(String str) {
        int k;
        String head;
        String tail;
        
        k = pattern.indexOf(variable);
        if (k == -1) {
            return pattern.equals(str)? NO_VAR : null;
        }
        if (pattern.lastIndexOf(variable) != k) {
            throw new XAssertionFailed(str);
        }
        head = pattern.substring(0, k);
        tail = pattern.substring(k + variableLength);
        if (str.startsWith(head) && str.endsWith(tail)) {
            return str.substring(head.length(), str.length() - tail.length());
        } else {
            return null;
        }
    }
}

