/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/PublicIdResolver.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util;

// TODO: ugly dependency
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/**
 ** SAX entity resolver which maps public identifiers to local resources.
 **
 ** @version    $Revision: 1.1 $
 **/
public class PublicIdResolver implements EntityResolver {
    /** DTD handling */
    public static final String WEB_APP_DTD_PUBLID_ID            = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String WEB_APP_DTD_JAVAPATH             = "/web-app_2_3.dtd";
    
    public static final String CONFIG_DTD_PUBLIC_ID             = "-//Slide//DTD Tamino WebDAV Server Store Configuration 1.0//EN";
    public static final String CONFIG_DTD_FILENAME              = "configuration.dtd";
    
    
    private Map entities;
    private boolean loadDtdFromClasspath = true;
    
    /**
     ** Create a new empty resolver.
     **/
    public PublicIdResolver() {
        entities = new HashMap();
    }
    
    /**
     ** Create a new empty resolver.
     ** @param loadDtdFromClasspath if true, the DTD is loaded from classpath - otherwise an
     **                             absolute file path is expected.
     **/
    public PublicIdResolver( boolean loadDtdFromClasspath ) {
        this();
        this.loadDtdFromClasspath = loadDtdFromClasspath;
    }
    
    /**
     ** Maps the specified public identifier to a resource.
     ** Caution:
     ** If the resolver was created with loadDtdFromClasspath=true, the resource will be loaded
     ** using <code>this.getClass().getResourceStream();</code>. Consequently, resource names always
     ** use slashes, even under Windows.
     **
     ** @param publicId      public identifier
     ** @param resourceName  a Java resource name (uses "/" on any platform)
     **/
    public void map(String publicId, String resourceName) {
        entities.put(publicId, resourceName);
    }
    
    /**
     ** Resolves the specified external entity. If the public identifier is mapped, the
     ** corresponding local resource is used. Otherwise, the systemId is used to locate
     ** the resource.
     **
     ** @param publicId Public identifier of the entity being referenced
     ** @param systemId System identifier of the entity being referenced
     **
     ** @return InputSource to read the specified entity.
     **/
    public InputSource resolveEntity(String publicId, String systemId) {
        String resourceName;
        InputStream in;
        
        // TODO: why?
        if( publicId == null && systemId != null && systemId.endsWith(CONFIG_DTD_FILENAME) )
            publicId = CONFIG_DTD_PUBLIC_ID;
        
        resourceName = (String) entities.get(publicId);
        if (resourceName != null) {
            try {
                if( loadDtdFromClasspath )
                    in = getClass().getResourceAsStream(resourceName);
                else
                    in = new BufferedInputStream( new FileInputStream(new File(resourceName)) );
            } catch (java.io.FileNotFoundException e) {
                in = null;
            }
            
            if (in != null) {
                return new InputSource(in);
            } else {
                // this is an internal error since we define the resource names
                throw new IllegalStateException("Resource not found: " + resourceName + " " + publicId + " " + loadDtdFromClasspath);
            }
        } else {
            return new InputSource(systemId);
        }
    }
}


