/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/XAssertionFailed.java,v 1.3 2004/07/30 06:52:17 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:17 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util;

import java.io.PrintStream;
import java.io.PrintWriter;


/**
 ** Thrown to indicate an assertion failure. Assertions include pre- and post-conditation which
 ** are assertions checked at the beginning and the end of a methdo .Should not be caught because
 ** this exception indicates a bug. Used instead of IllegalArgumentException or illegal state
 ** exception to provide logging and chained exceptions.
 **
 ** @author michael.hartmeier@softwareag.com
 **
 ** @version $Revision: 1.3 $
 **/
public class XAssertionFailed extends RuntimeException {
    /** the wrapped exception */
    private final Throwable e;
    
    /**
     * Default constructor.
     */
    public XAssertionFailed() {
        this("no message");
    }
    
    /**
     * Instantiate a XException with a message.
     * @param msg  the message
     */
    public XAssertionFailed(String msg) {
        this(msg, null);
    }
    
    /**
     * Construct a XException with a nested Exception.
     * @param e  the nested exception
     */
    public XAssertionFailed(Exception e) {
        this(e.getClass().getName () + ": " + e.getMessage(), e);
    }
    
    /**
     * Construct a XException with a nested exception and a message.
     * @param msg  the message
     * @param e  the nested exception
     */
    public XAssertionFailed(String msg, Throwable e) {
        super (msg);
        this.e = e;
    }
    
    /**
     * Print the stack trace to standard err.
     */
    public void printStackTrace() {
        printStackTrace (System.err);
    }
    
    /**
     * Print the stack trace to the given PrintStream.
     * @param s  the output stream to print the exception to
     */
    public void printStackTrace (PrintStream s) {
        super.printStackTrace (s);
        
        if (e != null) {
            e.printStackTrace (s);
        }
    }
    
    /**
     * Print the stack trace to the given PrintWriter.
     * @param s  the writer to print the exception to
     */
    public void printStackTrace (PrintWriter s) {
        super.printStackTrace (s);
        
        if (e != null) {
            e.printStackTrace ();
        }
    }
    
    /**
     * Return the nested (or wrapped) exception.
     * @return  the nested exception
     */
    public Throwable getWrappedException() {
        return e;
    }
    
    /**
     * Get the message.
     * @return the message
     */
    public String getMessage() {
        StringBuffer b = new StringBuffer();
        String m = super.getMessage();
        Throwable we = getWrappedException();
        
        if( m != null && m.length() > 0 ) {
            b.append( m );
        }
        else {
            b.append( getClass().getName() );
        }
        
        if( we != null ) {
            b.append( "\nCause: " ).append( we.getMessage() );
        }
        
        return b.toString();
    }
}


