/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/XThreadMap.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util;

import java.util.HashMap;
import java.util.Map;

/**
 * Maps Threads to Objects.
 * TODO: merge with common.XThreadMap if we have solved sync problems.
 */
public class XThreadMap {
    private final Map container;
    
    public XThreadMap() {
        this.container = new HashMap();
    }
    
    public synchronized Object get() {
        return container.get(Thread.currentThread());
    }
    
    public synchronized void add(Object obj) {
        if (container.put(Thread.currentThread(), obj) != null) {
            throw new XAssertionFailed("add: already mapped: " + Thread.currentThread().getName());
        }
    }
    
    public synchronized void remove() {
        if (container.remove(Thread.currentThread()) == null) {
            throw new XAssertionFailed("remove: not found: " + Thread.currentThread().getName());
        }
    }
    
}
