/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/cli/Abort.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util.cli;

import java.io.PrintStream;

/**
 * Reports problems to the user
 */
public class Abort extends Exception {
    private final Throwable details;
    
    public Abort(Throwable e) {
        this(e.getMessage(), e);
    }
    
    public Abort(String msg) {
        this(msg, null);
    }
    
    /**
     * @param  msg reported in normal mode
     * @param  details reported in verbose mode
     */
    public Abort(String msg, Throwable details) {
        super(msg);
        this.details = details;
    }

    public Abort(String msg, Abort details) {
        super(details == null? msg : msg + ": " + details.getMessage());
        this.details = details == null? null : details.details;
    }
    
    public String getInfo() {
        String nested;
        
        nested = (details == null)? null : details.getMessage();
        if (nested == null || nested.trim().length() == 0) {
            return getMessage();
        } else {
            return getMessage() + ": " + nested;
        }
    }

    public void printDetails(PrintStream dest) {
        if (details != null) {
            details.printStackTrace(dest);
        }
    }
}

