/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/cli/Actuals.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.slide.util.XAssertionFailed;

public class Actuals {
    private final Map map;
    private final List additionals;
    
    public Actuals() {
        this.map = new HashMap();
        this.additionals = new ArrayList();
    }
    
    public int size() {
        return map.size();
    }
    
    public Set names() {
        return map.keySet();
    }
    
    public void remove(String name) {
        if (map.remove(name) == null) {
            throw new XAssertionFailed(name);
        }
    }

    public void addAdditional(String value) {
        additionals.add(value);
    }
    
    public List getAdditionals() {
        return additionals;
    }
    
    public void add(String name, String value) {
        map.put(name, value);
    }

    public String getString(String name) {
        return getString(name, null);
    }
    
    public boolean getSwitch(String name) {
        return getString(name) != null;
    }
    
    public int getInt(String name, int dflt) throws Abort {
        String value;
        
        value = getString(name);
        if (value == null) {
            return dflt;
        } else {
            try {
                return Integer.parseInt(value);
            } catch (NumberFormatException e) {
                throw new Abort("number expected for parameter '" + name + "': " + value);
            }
        }
    }
    
    public String getString(String name, String dflt) {
        String value;
        
        value = (String) map.get(name);
        if (value == null) {
            return dflt;
        } else {
            return value;
        }
    }
}
