/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/cli/Formal.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.util.cli;

import org.apache.slide.util.Misc;
import org.apache.slide.util.XAssertionFailed;

public class Formal {
    public final String name;
    public final String literal;
    public final String value;
    
    public Formal(String name, String literal, String value) {
        if (name == null) {
            throw new XAssertionFailed();
        }
        if (literal == null) {
            throw new XAssertionFailed();
        }
        this.name = name;
        this.literal = literal;
        this.value = value;
    }
    
    public boolean equals(Object obj) {
        Formal f;
        
        if (obj instanceof Formal) {
            f = (Formal) obj;
            return name.equals(f.name) && literal.equals(f.literal) && Misc.eq(value, f.value);
        } else {
            return false;
        }
    }
}
