/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/jinx/Jinx.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.jinx;

import org.apache.slide.util.cli.Abort;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Jinx extends Task {
    private final StringBuffer buffer;
    
    public Jinx() {
        buffer = new StringBuffer();
    }
    
    public void addText(String expr) {
        buffer.append(expr);
    }
    
    public void execute() {
        try {
            new Expression(project).eval(buffer.toString());
        } catch (Abort e) {
            throw new BuildException(e.getMessage(), e);
        }
    }
}
