/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/jinx/Mount.java,v 1.1 2004/03/25 16:18:11 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:11 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.jinx;

import org.apache.slide.util.cli.Abort;
import org.apache.slide.util.reflect.Library;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/** Similar to Java's import directive, but ant 1.6 already has an import task. */
public class Mount extends Task {
    private String clazz;
    
    public Mount() {
        this.clazz = null;
    }

    public void setClass(String clazz) {
        this.clazz = clazz;
    }

    public void execute() throws BuildException {
        project.setSystemProperties();
        if (clazz == null) {
            throw new BuildException("missing class attribute");
        }
        try {
            Library.global.addImport(clazz);
        } catch (Abort e) {
            throw new BuildException(e.getMessage(), e);
        }
    }
}
