/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/nodeset/FileAdapter.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.nodeset;

import java.io.File;

public class FileAdapter implements Adapter {
    public static final FileAdapter INSTANCE = new FileAdapter();

    private FileAdapter() {
    }
    
    public int getDefaultMinDepth() {
        return 1;
    }
    public int getDefaultMaxDepth() {
        return NodeSet.DEPTH_INFINITE;
    }
    public String getSeparator() {
        // don't care about the platform!
        return "/";
    }

    public Object[] getChildren(Object fileObj) {
        File file;
        File[] files;
        
        file = (File) fileObj;
        if (!file.isDirectory()) {
            return NO_CHILDREN;
        }
        files = file.listFiles();
        if (files == null) {
            return NO_CHILDREN;
        } else {
            return files;
        }
    }
    
    public String getName(Object file) {
        return ((File) file).getName();
    }
}

