/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/os/CopyThread.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.os;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CopyThread extends Thread {
    private final InputStream src;
    private final OutputStream dest;
    private final byte[] buffer;
    
    private IOException exception;
    
    public CopyThread(InputStream src, OutputStream dest, int bufferSize) {
        this.src = src;
        this.dest = dest;
        this.exception = null;
        this.buffer = new byte[bufferSize];
    }
    
    public void run() {
        try {
            int len;
            
            while (true) {
                try {
                    len = src.read(buffer);
                    if (len == -1) {
                        return; // end of file, thread ends
                    }
                    dest.write(buffer, 0, len);
                } catch (IOException e) {
                    exception = e;
                    return;
                }
                yield();
            }
        } catch (Throwable e) {
            /* TODO: on unix machines, I see occasional
               java.lang.NullPointerException
                  at java.lang.System.arraycopy(Native Method)
                  at java.io.BufferedInputStream.read1(BufferedInputStream.java:227)
                  at java.io.BufferedInputStream.read(BufferedInputStream.java:277)
                  at java.io.FilterInputStream.read(FilterInputStream.java:90)
                  at CopyThread.run(CopyThread.java:38)
             */
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
    
    public void exception() throws IOException {
        if (exception != null) {
            throw exception;
        }
    }
}
