/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/os/Net.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.os;

import java.io.IOException;
import org.apache.slide.util.cli.Abort;

/**
 ** Start and stop a service.
 **/
public class Net {
    private final String name;
    
    public Net(String name) {
        this.name = name;
    }
    
    public String getDescription() {
        return name;
    }
    
    public void start() throws Abort, IOException {
        net("start");
    }
    
    public void stop() throws Abort, IOException {
        net("stop");
    }
    
    private void net(String cmd) throws Abort, IOException {
        Executable exec;
        int result;
        StringBuffer msg;
        
        if (Platform.isWindows()) {
            exec = new Executable("net", new String[] { cmd, name }, null);
            try {
                msg = new StringBuffer();
                result = exec.run(Platform.USER_DIR, msg, true);
                if (result != 0) {
                    throw new Abort("net returned error code " + result + ", message:\n" + msg);
                }
            } catch (Abort e) {
                throw new Abort("net command '" + exec + "' failed", e);
            }
        }
    }
}

