/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/reflect/Constr.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.slide.util.XAssertionFailed;

/**
 * Wraps a Java Constructor to make it useable as a Function.
 * Java Constructor means java.lang.reflect.Constructor.
 */
public class Constr extends Function {
    private final Constructor constr;

    public Constr(Constructor constr) {
        this.constr = constr;
    }

    public String getQName() {
        return constr.getName();
    }

    public int getModifiers() {
        return constr.getModifiers();
    }
    
    public Class getReturnType() {
        return constr.getDeclaringClass();
    }

    public Class[] getParameterTypes() {
        return constr.getParameterTypes();
    }

    public Object invoke(Object[] vals) throws InvocationTargetException {
        try {
            return constr.newInstance(vals);
        } catch (InstantiationException e) {
            throw new XAssertionFailed(e);
        } catch (IllegalAccessException e) {
            throw new XAssertionFailed("constructor invocation not allowed: " + e.getMessage(), e);
        }
    }
}
