/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/reflect/Function.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public abstract class Function {
    public abstract String getQName();
    
    public static String getName(String str) {
        return str.substring(str.lastIndexOf(".") + 1); // ok for idx -1
    }
    
    public String getName() {
        return getName(getQName());
    }
    
    public abstract int getModifiers();

    public boolean isStatic() {
        return Modifier.isStatic(getModifiers());
    }
    
    
    public abstract Class getReturnType();
    public abstract Class[] getParameterTypes();
    public abstract Object invoke(Object[] args) throws InvocationTargetException;
}
