/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/reflect/Library.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.slide.util.XAssertionFailed;
import org.apache.slide.util.cli.Abort;

public class Library {
    public static final Library global = new Library();
    public static final Function[] EMPTY = new Function[] {};
    
    //--
    
    private final Map imports;
    
    public Library() {
        imports = new HashMap();
    }
    
    // TODO: ugly dependency to ant exception
    public void addImport(String qname) throws Abort {
        Class cl;
        String name;
        
        try {
            cl = Class.forName(qname);
        } catch (ClassNotFoundException e) {
            throw new Abort("class not found: " + qname);
        }
        name = Function.getName(qname);
        if (getImport(name) != null) {
            throw new Abort("duplicate import: " + name);
        }
        imports.put(name, cl);
    }
    
    public Class getImport(String name) {
        return (Class) imports.get(name);
    }
    
    public Class getClass(String name) {
        Class cl;
        
        cl = getImport(name);
        if (cl == null) {
            try {
                cl = Class.forName(name);
            } catch (ClassNotFoundException e) {
                // fall through
            }
        }
        return cl;
    }
    
    /** @return never null */
    public Function[] getStatic(String name) throws Abort {
        Class cl;
        int idx;
        Function[] fns;
        String meth;
        
        cl = getClass(name);
        if (cl != null) {
            return getConstructors(cl);
        }
        idx = name.lastIndexOf(".");
        if (idx != -1) {
            cl = getClass(name.substring(0, idx));
            if (cl != null) {
                meth = name.substring(idx + 1);
                fns = getMethods(cl, meth);
                if (fns.length == 0) {
                    throw new Abort(cl.getName() + ": method not found: " + meth);
                } else {
                    return fns;
                }
            }
        }
        return EMPTY;
    }
    
    /** @return never null */
    public Constr[] getConstructors(Class cl) {
        Constructor[] constrs;
        Constr[] fns;
        int i;
        
        constrs = cl.getConstructors();
        fns = new Constr[constrs.length];
        for (i = 0; i < fns.length; i++) {
            fns[i] = new Constr(constrs[i]);
        }
        if (fns.length == 0) {
            throw new XAssertionFailed();
        }
        return fns;
    }
    
    /** @return never null */
    public Meth[] getMethods(Class cl) {
        Method[] methods;
        Meth[] fns;
        int i;
        
        methods = cl.getDeclaredMethods();
        fns = new Meth[methods.length];
        for (i = 0; i < fns.length; i++) {
            fns[i] = new Meth(methods[i]);
        }
        return fns;
    }
    
    /** @return never null */
    public Meth[] getMethods(Class cl, String name) {
        Method[] methods;
        Method m;
        Meth[] fns;
        int i;
        List lst;
        
        methods = cl.getDeclaredMethods();
        lst = new ArrayList();
        for (i = 0; i < methods.length; i++) {
            m = methods[i];
            if (name == null || m.getName().equals(name)) {
                lst.add(new Meth(methods[i]));
            }
        }
        fns = new Meth[lst.size()];
        lst.toArray(fns);
        return fns;
    }
    
    public String toString() {
        return "lib " + hashCode() + " " + imports;
    }
}
