/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/reflect/Primitives.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.reflect;

import java.util.ArrayList;
import java.util.List;

public class Primitives {
    public static final Primitives p;
    
    static {
        p = new Primitives();
        p.add(Boolean.class, Boolean.TYPE);
        p.add(Character.class, Character.TYPE);
        p.add(Byte.class, Byte.TYPE);
        p.add(Integer.class, Integer.TYPE);
        p.add(Long.class, Long.TYPE);
    };
    
    //--
    
    private final List wrappedLst;
    private final List unwrappedLst;
    
    private Primitives() {
        this.wrappedLst = new ArrayList();
        this.unwrappedLst = new ArrayList();
    }

    private void add(Class wrapped, Class unwrapped) {
        wrappedLst.add(wrapped);
        unwrappedLst.add(unwrapped);
    }
    
    public Class wrap(Class primitive) {
        return map(unwrappedLst, wrappedLst, primitive);
    }

    public Class unwrap(Class wrapped) {
        return map(wrappedLst, unwrappedLst, wrapped);
    }
    
    private static Class map(List keys, List values, Class key) {
        int i;
        
        i = keys.indexOf(key);
        return (i == -1)? null : (Class) values.get(i);
    }
}
