/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/src/util/org/apache/slide/util/reflect/Util.java,v 1.1 2004/03/25 16:18:12 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:12 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.util.reflect;

import java.lang.reflect.Array;

public class Util {
    // TODO: use in corresponding Strings class
    public static Object[] cons(Object head, Object[] tail) {
        Object[] result;
        
        result = arrayLike(tail, tail.length + 1);
        result[0] = head;
        System.arraycopy(tail, 0, result, 1, tail.length);
        return result;
    }

    // TODO: use in corresponding Strings class
    public static Object[] cdr(Object[] tail) {
        Object[] result;
        
        result = arrayLike(tail, tail.length - 1);
        System.arraycopy(tail, 1, result, 0, result.length);
        return result;
    }
    
    private static Object[] arrayLike(Object[] ar, int length) {
        Class cl;
        
        if (ar == null) {
            throw new IllegalArgumentException();
        }
        cl = ar.getClass().getComponentType();
        if (cl.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        return (Object[]) Array.newInstance(cl, length);
    }
}
