/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/MetaDataURLAccessorTest.java,v 1.3 2004/07/30 06:52:17 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:17 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore;

import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import java.io.StringReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.MetaDataURLAccessor;
import org.apache.slide.store.tamino.datastore.XUtilDBAccessor;
import org.apache.slide.util.os.Catalina;

/**
 * API for retrieving WebDAV-specific properties
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class MetaDataURLAccessorTest extends TestCase implements XGlobals {

    TXMLObject xmlObject;
    private static final String PRINT_STRING = " MetaDataURLAccessor TEST : ";


    /** home */
    String xdavhome;

    /** WebDAV port */
    String port;

    /** WebDAV host */
    String host;


    /** Tamino DB */
    String taminoDB = null;

    /** collection */
    String taminoCollection = null;


    String taminoUrl = null;


    /**
     ** Constructor.
     ** initialise Junit and check if relevant parameters are set.
     **
     **/
    public MetaDataURLAccessorTest ( String name ) {
        super ( name );
        taminoUrl = Configuration.get().getTaminoDatabaseUrl();
        taminoCollection = Configuration.get().taminoCollection;
        port = new Integer (Configuration.get().twsPort).toString();
        host = Configuration.get().twsHost;

    }



    protected void setUp () throws Exception {
        super.setUp();
        xmlObject = TXMLObject.newInstance (new StringReader ("<test/>"));
    }


    protected void println (String s) {
        System.out.println(PRINT_STRING + s);
    }

    public void testWebDAVaccessor () throws Exception {
        String context = Catalina.create().getContext();
        TConnectionFactory fac = TConnectionFactory.getInstance();
        TConnection connection = fac.newConnection (taminoUrl);
        XUtilDBAccessor utilAcessor = new XUtilDBAccessor(connection);

        MetaDataURLAccessor accessor = new MetaDataURLAccessor(connection);
        assertTrue("the URL schema must exist now", utilAcessor.isSchema(META_COLLECTION, URL_SCHEMA_NAME));

        accessor.deleteWebdavURL(taminoCollection);
        println("Reading default URL for " + taminoUrl + " == " + accessor.readWebdavURL(taminoCollection));
        assertEquals("Read URL", makeURL(), accessor.readWebdavURL(taminoCollection));

        accessor.storeWebdavURL(taminoCollection, "a", "b", "c");
        assertEquals("Read URL", makeURL("a", "b", "c"), accessor.readWebdavURL(taminoCollection));
        assertTrue("Check URL", accessor.checkWebdavURL(taminoCollection, "a", "b", "c"));


        accessor.storeWebdavURL(taminoCollection, "a", "b", "c");
        assertEquals("Read second URL", makeURL("a", "b", "c"), accessor.readWebdavURL(taminoCollection));
        assertTrue("Check URL", accessor.checkWebdavURL(taminoCollection, "a", "b", "c"));

        accessor.storeWebdavURL(taminoCollection, host, port, context);
        println("Stored URL for " + taminoUrl );
        assertEquals("Read URL", makeURL(host, port, context), accessor.readWebdavURL(taminoCollection));

        accessor.deleteWebdavURL(taminoCollection);
        println("Reading default URL for " + taminoUrl + " == " + accessor.readWebdavURL(taminoCollection));
        assertEquals("Read URL", makeURL(), accessor.readWebdavURL(taminoCollection));

    }


    private String makeURL (String host, String port, String context) {
        return "http://" + host + ":" + port + "/" + context + "/";
    }


    private String makeURL () {
        return "...";
    }


    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }

    public static Test suite() {
        return new TestSuite(MetaDataURLAccessorTest.class);
    }
}

