/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/XCheckNonXMLTest.java,v 1.3 2004/07/30 06:52:17 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:17 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.datastore;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.schema.XSchemaFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 ** Checks, if content ids are created properly and show the state properly
 **
 ** @author peter.nevermann@softwareag.com
 **
 ** @version 0.1
 **/
public class XCheckNonXMLTest extends XDatastoreBase {
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public XCheckNonXMLTest (String testMethodName) {
        super (testMethodName);
    }

    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }

    /**
     ** Return a TestSuite.
     **
     ** @pre   true
     ** @post  true
     **
     ** @return  TestSuite as a Test
     **/
    public static Test suite () {
        // automatically call each method starting with 'test'.
        TestSuite suite = new TestSuite (XCheckNonXMLTest.class);
        return suite;
    }



    /**
     * creates some schemas, XML and nonXML and creates XContentIDs for
     * dummy documents. Now checks, if the strings are created properly
     * and the state is ok.
     *
     */
    public void testContentId () throws Exception {
        XUtilDbSession session;

        TXMLObject nonXmlschema = XSchemaFactory.getNonXMLContentSchema (COLLECTION, "picture");
        schemaAccessor.define (nonXmlschema);
        TXMLObject nonXmlschema2 = XSchemaFactory.getNonXMLContentSchema (COLLECTION, XGlobals.NONXML_CONTENT);
        schemaAccessor.define (nonXmlschema2);
        TXMLObject xmlschema = XSchemaFactory.getXMLContentSchema (COLLECTION, "schubidu", "TSD3");
        schemaAccessor.define (xmlschema);
        XContentId contentId;
        XContentId contentId2;
        String expected;

        session = dbHandler.createUtilDbSession();
        expected = "1@picture@*nonXML*";
        contentId = createContentId("1", "picture", false);
        assertTrue(contentId.toString(), contentId.toString().equals (expected));
        assertTrue(contentId.isXml() == false);
        contentId2 = new XContentId (contentId.toString());
        assertTrue(contentId2.toString().equals (expected));
        assertTrue(contentId2.isXml() == false);

        expected = "2@xdav_nonXML";
        contentId = createContentId("2", XGlobals.NONXML_CONTENT, false);
        assertTrue(contentId.toString(), contentId.toString().equals (expected));
        assertTrue(contentId.isXml() == false);
        contentId2 = new XContentId (contentId.toString());
        assertTrue(contentId2.toString().equals (expected));
        assertTrue(contentId2.isXml() == false);

        expected = "3@schubidu";
        contentId = createContentId("3", "schubidu", true);
        assertTrue(contentId.toString(), contentId.toString().equals (expected));
        assertTrue(contentId.isXml() == true);
        contentId2 = new XContentId (contentId.toString());
        assertTrue(contentId2.toString().equals (expected));
        assertTrue(contentId2.isXml() == true);
    }


    private XContentId createContentId (String schema, String id, boolean isXml) {
        XContentId result = null;

        if (isXml)
            result = new XContentId (schema, id);
        else
            result = new XContentId (schema, id, false);

        return result;
    }
}

