/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/XContentWrapperTest.java,v 1.3 2004/07/30 06:52:17 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:17 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.datastore;

import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.content.NodeRevisionContent;


/**
 ** Tests the contentWrapper
 **
 ** @author martin.wallmer@softwareag.com
 **
 ** @version 0.1
 **/
public class XContentWrapperTest extends XDatastoreBase {
    
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public XContentWrapperTest( String testMethodName ) {
        super( testMethodName );
    }
    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    /*
     public static void main( String[] args ) {
     junit.textui.TestRunner.run( suite() );
     }
     */
    
    /**
     ** Return a TestSuite.
     **
     ** @pre   true
     ** @post  true
     **
     ** @return  TestSuite as a Test
     **/
    public static Test suite() {
        // automatically call each method starting with 'test'.
        TestSuite suite = new TestSuite(  XContentWrapperTest.class );
        
        
        // additionally add subsuites here
        // suite.addTest( XXX.suite() );
        // suite.addTest( YYY.suite() );
        
        
        // return the this suite
        return suite;
    }
    
    /**
     ** Construct your fixtures for the test cases in CaseTemplate.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void setUp() {
        System.out.println("setup");
        TPreference.getInstance().setUseApacheLoadExternalDTD( false );
        
    }
    
    /**
     ** Destruct your fixtures for the test cases in CaseTemplate.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void tearDown() {
    }
    
    /**
     ** This test ...
     **
     ** @pre   true
     ** @post  true
     **/
    public void testXml() {
        try {
            NodeRevisionContent nrc = getNodeRevisionContent ("joesgarage.xml");
            XContentWrapper cw = new XContentWrapper (nrc);
            
            System.out.println("Check, if joesgarage.xml is XML");
            assertTrue(cw.isXml () == true);
            String docType = cw.getDoctype ();
            System.out.println("Check, if docType is cd");
            assertTrue(docType.equals ("cd"));
            
            TNonXMLObject xmlObject = cw.getXMLObject ();
            assertEquals (xmlObject.getDoctype(), (cw.getDoctype()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     ** This test ...
     **
     ** @pre   true
     ** @post  true
     **/
    public void testNonXml() {
        NodeRevisionContent nrc = getNodeRevisionContent ("code.gif");
        try {
            XContentWrapper cw = new XContentWrapper (nrc);
            System.out.println("Check, if code.gif is nonXML");
            
            assertTrue(cw.isXml () == false);
            
            try {
                assertTrue(cw.getDoctype () == null);
            }
            catch (IllegalStateException e) {
                assertTrue(e instanceof IllegalStateException);
            }
            
            TNonXMLObject xmlObject = cw.getNonXMLObject ("image/gif");
            
        }
        catch (Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
    
    public void testNamespace () {
        
        NodeRevisionContent nrc = getNodeRevisionContent ("withNamespace.xml");
        
        try {
            XContentWrapper cw = new XContentWrapper (nrc);
            assertTrue(cw.isXml () == true);
            assertEquals ("http://myNamespace.de/", cw.getWeakDoctype().getNamespaceUri());
        }
        catch (Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
        
        
    }
    
    public void testDoctype () {
        
        NodeRevisionContent nrc = getNodeRevisionContent ("withDoctype.xml");
        
        try {
            XContentWrapper cw = new XContentWrapper (nrc);
            assertTrue(cw.isXml () == true);
        }
        catch (Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }
  
}

