/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/XDatastoreBase.java,v 1.1 2004/03/25 16:18:13 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:13 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore;

import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.common.IContent;
import org.apache.slide.store.tamino.common.XContent;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.tools.repairer.XTaminoClient;
import org.apache.slide.util.XException;

/**
 * This is an abstract base class for datastore tests.
 * The properties are.
 */
public abstract class XDatastoreBase extends TestCase implements XGlobals {
    private XTaminoClient tc;
    
    protected String COLLECTION;
    protected XDbHandler dbHandler;
    protected TSchemaDefinition2Accessor schemaAccessor;
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public XDatastoreBase (String testMethodName) {
        super (testMethodName);
    }
    
    protected synchronized void setUp () throws Exception {
        super.setUp();
        
        Configuration c = Configuration.get();
        COLLECTION = c.taminoCollection;
        tc = Configuration.get().newTaminoClient();
        tc.wipeDatabase();
        dbHandler = XDbHandler.newXDbHandler (c.namespace, c.getTaminoUrl(),
                                              c.taminoDatabase, COLLECTION,
                                              c.datastoreDbsession,
                                              c.datastoreAllowNonXml,
                                              c.datastoreAutoCreateXmlSchema);
        TConnection taminoConnection  = TConnectionFactory.getInstance().newConnection(Configuration.get().getTaminoDatabaseUrl());
        
        schemaAccessor = taminoConnection.newSchemaDefinition2Accessor(TDOMObjectModel.getInstance());
    }
    
    
    protected void tearDown() throws Exception {
        super.tearDown();
        tc.wipeDatabase();
    }
    
    protected String writeContent (InputStream in, IDbSession session) throws XException
    {
        NodeRevisionContent nrc = new NodeRevisionContent ();
        nrc.setContent (in);
        NodeRevisionDescriptor nrd = new NodeRevisionDescriptor ();
        nrd.setContentType("text/xml");
        
        IContent content = new XContent (nrc, nrd);
        session.createContent (content);
        session.commit();
        return content.getContentId();
    }
    
    protected NodeRevisionContent getNodeRevisionContent (String filename) {
        URL contentURL = getClass().getResource (filename);
        assertTrue(filename + " not found", contentURL != null);
        NodeRevisionContent nrc = new NodeRevisionContent();
        
        String contentDir = (new File(contentURL.getFile())).getParent();
        File contentFile = new File (contentDir + File.separator + filename);
        
        System.out.println("\nFound " + filename + " in directory: " + contentDir);
        
        try {
            InputStream is = new FileInputStream (contentFile);
            nrc.setContent (is);
        }
        catch (Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
        return nrc;
    }
    
    
}



