/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/XDbSessionTest.java,v 1.3 2004/07/30 06:52:18 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.datastore;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.store.tamino.common.IContent;
import org.apache.slide.store.tamino.common.IDescriptors;
import org.apache.slide.store.tamino.jdomobjects.XDescriptors;
import org.apache.slide.store.tamino.jdomobjects.XDescriptorsGenerator;
import org.apache.slide.util.XException;

/**
 ** @author peter.nevermann@softwareag.com
 **
 ** @version 0.1
 **/
public class XDbSessionTest extends XDatastoreBase {
    private IDbSession session;
    private XDescriptors descriptors;
    private XDescriptorsGenerator gen;

    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public XDbSessionTest (String testMethodName) {
        super (testMethodName);
    }

    protected void setUp() throws Exception {
        super.setUp();

        gen = new XDescriptorsGenerator (XDescriptorsGenerator.DOC);
        session = dbHandler.getDbSession();
        if (session == null) {
            session = dbHandler.createDbSession();
        }
    }

    public void testStoreDescriptors() throws Exception {
        Collection c;
        Iterator uuris;

        descriptors = gen.getDescriptors ();
        c = new ArrayList();
        c.add (descriptors);

        session.processDescriptors (c);
        session.commit();

        uuris = dbHandler.adminDbSession.getDescriptorsAccessor().getUurisMap(XPathFactory.uuris(COLLECTION)).keySet().iterator();
        assertTrue("no descriptors", uuris.hasNext());

        session.processDescriptors (c);
        session.commit();

        uuris = dbHandler.adminDbSession.getDescriptorsAccessor().getUurisMap(XPathFactory.uuris(COLLECTION)).keySet().iterator();
        assertTrue("one descriptor", uuris.hasNext());
    }

    /**
     ** tests descriptos
     **
     ** @pre   true
     ** @post  true
     **/
    public void testStoreChangedDescriptors () throws XException {
        descriptors = gen.getDescriptors ();
        NodeRevisionDescriptors nodeRevDesc = descriptors.getRevisionDescriptors("myUri");
        String uri = nodeRevDesc.getUri();
        assertNotNull(uri);

        Collection c = new ArrayList();
        c.add (descriptors);

        // store it in Tamino
        session.processDescriptors (c);
        session.commit();

        // retrieve from Tamino
        IDescriptors iDesc = session.readDescriptor(descriptors.getUuri());
        assertNotNull(iDesc);
        iDesc.setReadOnly(false);
        NodeLock lock = new NodeLock ("lockId", "objectUri", "subjectUri", "typeUri", new Date(), false, false);

        iDesc.setNodeLock (lock);

        // store it in Tamino
        c = new ArrayList();
        c.add (iDesc);

        session.processDescriptors (c);
        session.commit();

        Iterator uuris = dbHandler.adminDbSession.getDescriptorsAccessor().getUurisMap(XPathFactory.uuris(COLLECTION)).keySet().iterator();
        assertTrue("one descriptor", uuris.hasNext());
    }


    public void testWriteReadContent () throws Exception {
        InputStream in = XDbSession.class.getResourceAsStream ("joesgarage.xml");
//        NodeRevisionContent nrc = new NodeRevisionContent ();
//        nrc.setContent (in);
//        NodeRevisionDescriptor nrd = new NodeRevisionDescriptor ();
//        nrd.setContentType("text/xml");
//
//        IContent content = new XContent (nrc, nrd);
//        session.createContent (content);
//        session.commit();

        String contentId = writeContent (in, session);
        
        IContent readContent = session.readContent(contentId);
        assertTrue("read the content:", readContent != null);
    }

    private static void compareFiles (File file1, File file2) {
        try {
            FileInputStream is1 = new FileInputStream (file1);
            FileInputStream is2 = new FileInputStream (file2);
            int byte1;
            int byte2;
            int i = 0;
            do {
                i++;
                byte1 = is1.read();
                byte2 = is2.read();

                if (byte1 != byte2)
                    assertTrue("difference at position " + i, false);

            } while (byte1 != -1 && byte2 != -1);
        }
        catch (Exception e) {
            e.printStackTrace();
            assertTrue(false);
        }
    }

    //--

    public static Test suite () {
        // automatically call each method starting with 'test'.
        TestSuite suite = new TestSuite (XDbSessionTest.class);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run( suite() );
    }
}

