/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/XUtilDBAccessorTest.java,v 1.3 2004/07/30 06:52:18 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.apache.slide.store.tamino.datastore;

import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.XUtilDBAccessor;
import junit.framework.TestCase;

/**
 * API for retrieving WebDAV-specific properties
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class XUtilDBAccessorTest extends TestCase implements XGlobals  {


    private static final String TAMINO_TEST_COLLECTION = "UtilTestCollection";
    private static final String PRINT_STRING = " XUtilDBAccessorTest TEST : ";


//    /** home */
//    String xdavhome;
//
//    /** WebDAV port */
//    String port;
//
//    /** WebDAV host */
//    String host;
//
//    /** Tamino DB */
//    String taminoDB = null;
//

    private String getTaminoDbUrl() {
        String result = Configuration.get().getTaminoUrl();
        result = result + "/";
        result = result + Configuration.get().taminoDatabase;

        return result;
    }




    /**
     ** Constructor.
     ** initialise Junit and check if relevant parameters are set.
     **
     **/
    public XUtilDBAccessorTest ( String name ) {
        super ( name );
    }



    protected void setUp () throws Exception {
        super.setUp();
    }


    protected void println (String s) {
        System.out.println(PRINT_STRING + s);
    }

    public void testWebDAVaccessorSchema () {
        // webDAVaccessorSchema(TSD2_SCHEMA_VERSION);
        webDAVaccessorSchema(TSD4_SCHEMA_VERSION);
    }


    public void testWebDAVaccessorSchemaVersion () throws Exception {
        TConnectionFactory fac = TConnectionFactory.getInstance();
        String collectionName = getCollectionName("");
        String schemaName = "schemaTest";
        String schemaVersion = TSD4_SCHEMA_VERSION;


        TConnection connection = fac.newConnection(getTaminoDbUrl());
        XUtilDBAccessor accessor = new XUtilDBAccessor(connection);

        try {accessor.deleteSchema(collectionName, null );} catch (Exception e){}
        assertEquals("empty collection", schemaVersion, accessor.getSchemaLanguage(collectionName));

        accessor.createSchema (collectionName, schemaName, null );
        assertEquals("TSD3 created", schemaVersion, accessor.getSchemaLanguage(collectionName));

        accessor.deleteSchema(collectionName, null );
        assertEquals("TSD3 deleted/empty", schemaVersion, accessor.getSchemaLanguage(collectionName));

        accessor.createSchema (collectionName, schemaName, null );
        assertEquals("TSD3 re-created", schemaVersion, accessor.getSchemaLanguage(collectionName));

        accessor.deleteSchema(collectionName, null );
        assertEquals("TSD3 deleted/empty", schemaVersion, accessor.getSchemaLanguage(collectionName));

//            accessor.createSchema(TSD2_SCHEMA_VERSION, collectionName, schemaName, null );
//            assertEquals("TSD2 created", TSD2_SCHEMA_VERSION, accessor.getSchemaLanguage(collectionName));
//
//            accessor.deleteSchema(collectionName, null );
//            assertEquals("TSD2 deleted/empty", TSD3_SCHEMA_VERSION, accessor.getSchemaLanguage(collectionName));
//
//            accessor.createSchema(TSD2_SCHEMA_VERSION, collectionName, schemaName, null );
//            assertEquals("TSD2 re-created", TSD2_SCHEMA_VERSION, accessor.getSchemaLanguage(collectionName));
//
//            accessor.deleteSchema(collectionName, null );
//            assertEquals("TSD2 deleted/empty", TSD3_SCHEMA_VERSION, accessor.getSchemaLanguage(collectionName));
    }


    public void webDAVaccessorSchema (String schemaVersion) {
        TConnectionFactory fac = TConnectionFactory.getInstance();
        String collectionName = getCollectionName(schemaVersion);
        String schemaName = "schemaTest" + schemaVersion;
        try {


            TConnection connection = fac.newConnection(getTaminoDbUrl());

            XUtilDBAccessor accessor = new XUtilDBAccessor(connection);

            println("checked schema" + schemaVersion + " for " + getTaminoDbUrl() + "/" + collectionName);
            assertEquals("initial check schema version", schemaVersion, accessor.getSchemaLanguage(collectionName));

            try {accessor.deleteSchema(collectionName, schemaName );} catch (Exception e){}
            assertTrue("check if schema does not already exists" + schemaVersion, !accessor.isSchema(collectionName, schemaName));

            accessor.createSchema (collectionName, schemaName, null );
            println("created schema" + schemaVersion + "  for " + getTaminoDbUrl() + "/" + collectionName);
            assertEquals("after creation check schema version" + schemaVersion, schemaVersion, accessor.getSchemaLanguage(collectionName));
            assertTrue("after creation check schema" + schemaVersion, accessor.isSchema(collectionName, schemaName));

            accessor.deleteSchema(collectionName, schemaName );
            println("deleted schema" + schemaVersion + "  for " + getTaminoDbUrl() + "/" + collectionName);
            assertTrue("after creation check schema" + schemaVersion, !accessor.isSchema(collectionName, schemaName));


            println("checked schema" + schemaVersion + "  for " + getTaminoDbUrl() + "/" + collectionName);
            assertEquals("final check schema version", schemaVersion, accessor.getSchemaLanguage(collectionName));



        }
        catch (Exception e) {
            e.printStackTrace();
            fail (e.getMessage());
        }
    }


    private String getCollectionName (String schemaVersion) {
        return TAMINO_TEST_COLLECTION + schemaVersion;
    }





    /**
     ** main entry to be able to start the test suite with out Junit.
     **
     **/

    public static void main (String args[]) {
        try {
            new XUtilDBAccessorTest ( "XUtilDBAccessorTest" ).testWebDAVaccessorSchema();
            new XUtilDBAccessorTest ( "XUtilDBAccessorTest" ).testWebDAVaccessorSchemaVersion();
        }
        catch (Exception e) { e.printStackTrace();  }
    }
}


