/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/schema/XBadSchemaExceptionTest.java,v 1.3 2004/07/30 06:52:18 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;


// import list
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;



/**
 ** A Test for the XBadSchemaException class.
 **
 ** @version $Revision: 1.3 $
 **
 ** @author rsk@softwareag.com
 **/
public class XBadSchemaExceptionTest extends TestCase {
    
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public XBadSchemaExceptionTest( String testMethodName ) {
        super( testMethodName );
    }
    
    
    /**
     ** Return a TestSuite.
     **
     ** @pre   true
     ** @post  true
     **
     ** @return  TestSuite as a Test
     **/
    public static Test suite() {
        return new TestSuite(  XBadSchemaExceptionTest.class );
    }
    
    
    /**
     ** Construct your fixtures for the test cases.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    
    /**
     ** Destruct your fixtures for the test cases.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    
    
    /**
     ** Tests the default constructor.
     **/
    public void testDefaultConstructor() {
        
        XBadSchemaException exception = new XBadSchemaException();
        assertEquals(getExpectedMessage(null, null), exception.getMessage());
        assertEquals(null, exception.getWrappedException());
    }
    
    /**
     ** Tests the constructor that takes a message as parameter.
     **/
    public void testMessageConstructor() {
        
        String message = "Aloha";
        XBadSchemaException exception = new XBadSchemaException(message);
        assertEquals(getExpectedMessage(message, null), exception.getMessage());
        assertEquals(null, exception.getWrappedException());
    }
    
    /**
     ** Tests the constructor that takes an exception as parameter.
     **/
    public void testExceptionConstructor() {
        
        Exception wrappedException = new NullPointerException();
        XBadSchemaException exception = new XBadSchemaException(wrappedException);
        assertEquals(getExpectedMessage(wrappedException.getClass().getName () + ": " + wrappedException.getMessage(), wrappedException), exception.getMessage());
        assertEquals(wrappedException, exception.getWrappedException());
    }
    
    /**
     ** Tests the constructor that takes an exception and a message as parameter.
     **/
    public void testMessageAndExceptionConstructor() {
        
        String message = "Aloha";
        Exception wrappedException = new NullPointerException();
        XBadSchemaException exception = new XBadSchemaException(message, wrappedException);
        assertEquals(getExpectedMessage(message, wrappedException), exception.getMessage());
        assertEquals(wrappedException, exception.getWrappedException());
    }
    
    private String getExpectedMessage(String message, Exception wrappedException) {
        
        String expectedMessage = message;
        if ( (expectedMessage == null) || (expectedMessage.length() == 0) ) {
            expectedMessage = XBadSchemaException.class.getName();
        }
        if (wrappedException != null) {
            expectedMessage += "\nCause: " + wrappedException.getMessage();
        }
        return expectedMessage;
    }
    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }
    
}

