/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/schema/XDoctypeHandlerTest.java,v 1.3 2004/07/30 06:52:18 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;

import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.IContentCollection;
import org.apache.slide.store.tamino.datastore.XUtilDBAccessor;
import org.apache.slide.util.XException;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import org.jdom.Document;

/**
 * XDoctypeTest.java
 *
 * @author Created by Omnicore CodeGuide
 */
public class XDoctypeHandlerTest extends TestCase implements XGlobals {

    private TConnection taminoConnection = null;

    Document tsd2Schema;
    Document tsd3Schema;
    String tsd3Name = "x_mydoc.xml";

    String TAMINOBASE;
    String DATABASE;
    String COLLECTION;

    public XDoctypeHandlerTest (String name) {
        super (name);
    }

    protected void setUp () throws Exception {
        super.setUp();

        String uri;

        TAMINOBASE =    Configuration.get().getTaminoUrl();
        DATABASE =      Configuration.get().taminoDatabase;
        COLLECTION =    Configuration.get().taminoCollection;

        uri = Configuration.get().getTaminoDatabaseUrl();
        taminoConnection = TConnectionFactory.getInstance().newConnection(uri);

    }

    protected void tearDown() throws Exception {
        System.out.println("tearDown");
        XUtilDBAccessor acc = new XUtilDBAccessor (taminoConnection);
        XDoctypeHandler dtHandler = new XDoctypeHandler (taminoConnection);

        IContentCollection collection = getCollection();
        XDoctype docType = dtHandler.getDoctype (collection, "x:hugo", "http://hugo.de", true);
        String prefName = docType.getPrefixedName();
        deleteSchema (acc, "hugo");
        deleteSchema (acc, prefName);
    }


    private void deleteSchema (XUtilDBAccessor acc, String prefName) {
        try {
            acc.deleteSchema (COLLECTION, prefName);
        } catch (XException e) {
            e.printStackTrace();
        }
    }


    public void testDoctypeHandler () throws Exception {

        XDoctypeHandler dtHandler = new XDoctypeHandler (taminoConnection);

        IContentCollection collection = getCollection();

        XDoctype docType = dtHandler.getDoctype (collection, "hugo", "", true);
        assertEquals ("", docType.getNamespaceUri());
        assertEquals ("hugo", docType.getPrefixedName());
        assertEquals ("hugo", docType.getName());

        docType = dtHandler.getDoctype (collection, "x:hugo", "http://hugo.de", true);
        assertEquals ("http://hugo.de", docType.getNamespaceUri());
        assertEquals ("hugo", docType.getName());

        docType = dtHandler.getDoctype (collection, "y:hugo",  "http://hugo.de", false);
        assertEquals ("http://hugo.de", docType.getNamespaceUri());
        assertEquals ("hugo", docType.getName());
    }


    IContentCollection getCollection () throws Exception {
        MockControl ctrlCollection = EasyMock.controlFor (IContentCollection.class);
        IContentCollection mockCollection =
            (IContentCollection)ctrlCollection.getMock();

        mockCollection.getSchemaVersion();
        ctrlCollection.setReturnValue (TSD3_SCHEMA_VERSION);

        mockCollection.getCollectionName ();
        ctrlCollection.setReturnValue (COLLECTION);

        mockCollection.getUri ();
        ctrlCollection.setReturnValue
            (TAMINOBASE + "/" + DATABASE + ":" + COLLECTION);

        ctrlCollection.activate();
        return mockCollection;

    }

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }


    public static Test suite() {
        return new TestSuite(XDoctypeHandlerTest.class);
    }
}

