/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/schema/XDoctypeTest.java,v 1.1 2004/03/25 16:18:14 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;


import org.apache.slide.store.tamino.common.XGlobals;
import junit.framework.TestCase;
import org.jdom.Document;

public class XDoctypeTest extends TestCase {
    
    
    Document tsd2Schema;
    Document tsd3Schema;
    String tsd3Name = "x_mydoc.xml";
    
    public XDoctypeTest (String name) {
        super (name);
    }
    
    protected void setUp () throws Exception {
        super.setUp();
        
    }
    
    public void testDoctype () {
        
        XDoctype docType = new XDoctype ("hugo", null);
        assertNull  (docType.getNamespaceUri());
        assertEquals ("hugo", docType.getPrefixedName());
        assertEquals ("hugo", docType.getName());
        assertTrue (docType.isWeak());
        
        docType = new XDoctype ("x:hugo", "http://hugo.de");
        assertEquals ("http://hugo.de", docType.getNamespaceUri());
        assertEquals ("x:hugo", docType.getPrefixedName());
        assertEquals ("hugo", docType.getName());
        docType.makeStrong ("a");
        assertEquals ("a:hugo", docType.getPrefixedName());
        assertTrue (docType.isWeak() == false);
        
        
        docType = new XDoctype ("hugo", "http://hugo.de");
        assertEquals ("http://hugo.de", docType.getNamespaceUri());
        assertEquals (XGlobals.DUMMY_NAMESPACE_PREFIX, docType.getNamespacePrefix());
        assertEquals ("hugo", docType.getName());
        
    }
}

