/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/schema/XSchemaFactoryTest.java,v 1.3 2004/07/30 06:52:18 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;

import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.datastore.XDbSession;
import org.apache.slide.store.tamino.datastore.XUtilDBAccessor;
import org.apache.slide.store.tamino.datastore.schema.XSchemaFactory;
import org.jdom.Namespace;

/**
 *
 * @author martin.wallmer@softwareag.com
 *
 * @version $Revision: 1.3 $
 */
public class XSchemaFactoryTest extends TestCase implements XGlobals  {

    private TConnection connection ;

    private String schemaLanguage;


    /**
     ** Constructor.
     ** initialise Junit and check if relevant parameters are set.
     **
     **/
    public XSchemaFactoryTest ( String name ) {
        super ( name );
    }

    /**
     * Method setUp. Create the namespace specific schemas
     *
     * @throws   Exception
     *
     */
    public void setUp () throws Exception {
        super.setUp();
        connection = Configuration.get().newConnection();

        XUtilDBAccessor utilDbAcc = new XUtilDBAccessor(connection);
        schemaLanguage = utilDbAcc.getSchemaLanguage(META_COLLECTION);

        KnownPropertyList kpl =
            XKnownPropertyHelper.getKnownPropertyList (schemaLanguage);

        Iterator it = XKnownPropertyHelper.getKnownPropertyList (schemaLanguage).getNamespaceIterator ();
        while (it.hasNext()) {
            Namespace namespace = (Namespace)it.next();
            String schemaName = namespace.getPrefix();
            if (!utilDbAcc.getSchemaNames (XDbSession.META_COLLECTION).contains (schemaName)) {
                utilDbAcc.createKnownPropertySchema (namespace);
            }
        }
    }

    public void tearDown () throws Exception {
        super.tearDown();
        removeAllSchemas (connection);

        XUtilDBAccessor utilDbAcc = new XUtilDBAccessor(connection);

        KnownPropertyList kpl =
            XKnownPropertyHelper.getKnownPropertyList (schemaLanguage);

        Iterator it = kpl.getNamespaceIterator ();

        while (it.hasNext()) {
            Namespace namespace = (Namespace)it.next();
            String schemaName = namespace.getPrefix();

            if (utilDbAcc.getSchemaNames (XDbSession.META_COLLECTION).contains (schemaName)) {
                connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).
                    undefine(META_COLLECTION, schemaName);
            }
        }
        connection.close();
    }


    public void testGetAllTSD3Schemas () throws Exception {
        List schemas = XSchemaFactory.getAllSchemas (connection, schemaLanguage);
        XUtilDBAccessor utilDbAcc = new XUtilDBAccessor(connection);

        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).undefine(META_COLLECTION, null);

        // re-create the received Schemas
        removeAllSchemas(connection);

        // check the schemas for known properties
        Iterator it = XKnownPropertyHelper.getKnownPropertyList (schemaLanguage).getNamespaceIterator ();
        while (it.hasNext()) {
            Namespace namespace = (Namespace)it.next();
            String schemaName = namespace.getPrefix();
            if (!utilDbAcc.getSchemaNames (XDbSession.META_COLLECTION).contains (schemaName)) {
                utilDbAcc.createKnownPropertySchema (namespace);
            }
        }

        Iterator iter2 = schemas.iterator();
        while (iter2.hasNext()) {
            TXMLObject schema = (TXMLObject)iter2.next();
            //schema.writeTo (System.out);
            connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema);
        }
    }

    public void testCreateMetaDataSchema () throws Exception {
        TXMLObject schema3 = XSchemaKnownProperty.getMetadataSchema("testMetaData3", XGlobals.TSD3_SCHEMA_VERSION);
        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema3);
    }


    public void testCreateMetaDataSchemaWithNamespace () throws Exception {
        TXMLObject schema3 = XSchemaKnownProperty.getMetadataSchema("abcdef_testMetaData3_1", TSD4_SCHEMA_VERSION);
        //schema3.writeTo (System.out);

        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema3);
        schema3 = XSchemaKnownProperty.getMetadataSchema("xsv_testMetaData3_2", TSD4_SCHEMA_VERSION);

        //schema3.writeTo (System.out);

        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema3);

        //        schema3 = XSchemaFactory.getMetadataSchema("abcdef:testMetaData3_3", TSD3_SCHEMA_VERSION, TAMINO_NAMESPACE_PREFIX));
        //        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema3);
//
        //        schema3 = XSchemaFactory.getMetadataSchema("xsv:testMetaData3_4", TSD3_SCHEMA_VERSION, TAMINO_NAMESPACE_PREFIX));
        //        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema3);
    }


    public void testCreateContentDataSchema () throws Exception {
        removeAllSchemas(connection);
        TXMLObject schema3 = XSchemaFactory.getXMLContentSchema(META_COLLECTION, "testContentData", TSD3_SCHEMA_VERSION);
        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema3);
    }

    public void testCreateContentDataSchemaWithNamespace () throws Exception {

        removeAllSchemas(connection);
        TXMLObject schema4 = XSchemaFactory.getXMLContentSchema
            (META_COLLECTION, "abcdef_testContentData3_1", XGlobals.TSD4_SCHEMA_VERSION);
        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema4);

        schema4 = XSchemaFactory.getXMLContentSchema
            (META_COLLECTION, "xsv_testContentData3_2", XGlobals.TSD4_SCHEMA_VERSION);

        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema4);

        schema4 = XSchemaFactory.getXMLContentSchema(META_COLLECTION, "abcdef_testContentData3_3", TAMINO_NAMESPACE_URI);
        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema4);

        schema4 = XSchemaFactory.getXMLContentSchema(META_COLLECTION, "xsv_testContentData3_4", TAMINO_NAMESPACE_URI);
        connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).define(schema4);
    }

    private static void removeAllSchemas (TConnection connection) throws Exception {
        // delete the received Schemas
        String schemaLanguage =
            new XUtilDBAccessor (connection).getSchemaLanguage(META_COLLECTION);

        // do not delete the namespace specific scheamas (D and xsv)
        KnownPropertyList kpl = XKnownPropertyHelper.getKnownPropertyList (schemaLanguage);
        Iterator nsIter = kpl.getNamespaceIterator();

        Set allSchemaNames = new XUtilDBAccessor(connection).getSchemaNames(META_COLLECTION);
        while (nsIter.hasNext ()) {

            Object o = nsIter.next();
            String namespaceSchemaName = ((Namespace)o).getPrefix();
            allSchemaNames.remove (namespaceSchemaName);
        }

        Iterator it = allSchemaNames.iterator();

        while (it.hasNext()) {
            String schemaName = (String)it.next();
            connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).undefine(META_COLLECTION, schemaName);
        }

        try {
            connection.newSchemaDefinition3Accessor(TDOMObjectModel.getInstance()).undefine(META_COLLECTION, null);
        } catch (com.softwareag.tamino.db.api.accessor.TUndefineException e) {} // ignore the exception

    }



    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    public static Test suite() {
        return new TestSuite(XSchemaFactoryTest.class);
    }
}




