/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/schema/XSchemaFactoryTestWithKnownProp.java,v 1.1 2004/03/25 16:18:14 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;

import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.common.Domain;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.datastore.XUtilDBAccessor;
import org.apache.slide.util.JDom;
import org.jaxen.XPath;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Document;

public class XSchemaFactoryTestWithKnownProp extends TestCase {

    Configuration config;

    public static Test suite() {
        return new TestSuite(  XSchemaFactoryTestWithKnownProp.class );
    }
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }

    public XSchemaFactoryTestWithKnownProp (String name) {
        super (name);
    }

    public void setUp () throws Exception {
        config = Configuration.get();
    }


    public void testCreate () throws Exception {
        Domain.setInitialized(true);
        TXMLObject schema3 = XSchemaKnownProperty.getMetadataSchema("testMetaData3", "TSD3");
        StringWriter wr = new StringWriter ();

        schema3.writeTo (wr);
        Document doc = JDom.forString (wr.toString());

        //System.out.println(JDom.toString (doc));

        XPath xPath;

        //String xPathString = "/xs:schema/xs:element/xs:complexType/xs:sequence/xs:choice/xs:element/xs:complexType/xs:sequence/xs:element/xs:complexType/xs:sequence/xs:element[@name=\"livePropertyList\"]/xs:complexType/xs:choice/xs:element/@name";

        String xPathString = "/xs:schema/xs:element/xs:complexType/xs:sequence/xs:choice/xs:element/xs:complexType/xs:sequence/xs:element/xs:complexType/xs:sequence/xs:element[@name=\"indexedPropertyList\"]/xs:complexType/xs:sequence/xs:element/@name";

        xPath = new JDOMXPath (xPathString);

        xPath.addNamespace ("xs", "http://www.w3.org/2001/XMLSchema");

        Iterator it = xPath.selectNodes (doc.getRootElement()).iterator();

        List col = new ArrayList();
        while (it.hasNext()) {
            Attribute at = (Attribute)it.next();
            col.add (at.getValue());
        }

        // TODO: replace by whatever is on vogue now.
        //        it = XIndexedPropertyList.indexedPropertyIterator();
        //        while (it.hasNext()) {
        //            String testName = ((IndexedProperty)it.next()).getName();
        //            assertTrue ("check for " + testName, col.contains (testName));
        //        }

        //System.out.println (JDom.toString (el));
        // JDom.toString(e);

    }

    public void XestXxx () throws Exception {
        TConnection connection = config.newConnection();
        System.out.println (config);
        String tsd = new XUtilDBAccessor(connection).getSchemaLanguage (config.taminoCollection);
        System.out.println(tsd);
    }
}

