/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/schema/XSchemaTypeTest.java,v 1.3 2004/07/30 06:52:18 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.schema;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 ** A test for the XSchemaType class.
 **
 ** @version $Revision: 1.3 $
 **
 ** @author rsk@softwareag.com
 **/
public class XSchemaTypeTest extends TestCase {
    
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public XSchemaTypeTest( String testMethodName ) {
        super( testMethodName );
    }
    
    
    /**
     ** Return a TestSuite.
     **
     ** @pre   true
     ** @post  true
     **
     ** @return  TestSuite as a Test
     **/
    public static Test suite() {
        return new TestSuite(  XSchemaTypeTest.class );
    }
    
    
    /**
     ** Construct your fixtures for the test cases.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void setUp() throws Exception {
        super.setUp();
    }
    
    
    /**
     ** Destruct your fixtures for the test cases.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    
    /**
     ** A test for the equals() method.
     **/
    public void testEquals() {
        XSchemaType type;
        
        type = new XSchemaType("1");
        assertEquals(type, type);
        assertFalse(type.equals(new XSchemaType("1")));
        assertFalse(type.equals(new XSchemaType("2")));
    }
    
    
    /**
     ** A test for the hashCode() method.
     **/
    public void testHashCode() {
        assertTrue(new XSchemaType("1").hashCode() != new XSchemaType("1").hashCode());
        assertTrue(new XSchemaType("1").hashCode() != new XSchemaType("2").hashCode());
    }
    
    /**
     ** A test for the toString() method.
     **/
    public void testToString() {
        assertEquals("TSD7", new XSchemaType("7").toString());
    }
    
    /**
     ** A test for the toString() method.
     **/
    public void testGetVersionString() {
        assertEquals("TSD3", new XSchemaType("3").getVersionString());
    }
    
    
    /**
     ** A test for the getSchemaTypeForVersionString() method.
     **/
    public void testGetSchemaTypeForVersionString() {
        assertNotNull(XSchemaType.lookup("TSD3"));
        assertNotNull(XSchemaType.lookup("TSD4"));
        
        assertNull(XSchemaType.lookup("TSD2"));
        assertNull(XSchemaType.lookup("TSD1"));
        assertNull(XSchemaType.lookup("TSD5"));
        assertNull(XSchemaType.lookup(""));
        assertNull(XSchemaType.lookup(null));
        assertNull(XSchemaType.lookup("jdshfkds"));
    }
    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }
    
}

