/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/datastore/search/XPathTest.java,v 1.1 2004/03/25 16:18:14 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.datastore.search;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.MockControl;

public class XPathTest extends TestCase {

    private MockControl ctrlFilter;
    private IContentQueryFilter mockFilter;



    private static final String XP01 =
        "/xdav_nonXML/properties/meta/office:document-meta/office:meta/dc:creator";


    private static final String CF01 =
        "[@ino:id='18' or @ino:id='20' or @ino:id='17']";

    private static final String S01 =
        "sortall (./properties/meta/office:document-meta/office:meta/dc:title ascending)";

    public XPathTest (String testMethodName) {
        super (testMethodName);
    }

    protected void setUp () throws Exception {
        super.setUp();

        ctrlFilter = EasyMock.controlFor (IContentQueryFilter.class);
        mockFilter = (IContentQueryFilter)ctrlFilter.getMock();

        mockFilter.getXPathFilter ("xdav_nonXML");
        ctrlFilter.setReturnValue (CF01);
        ctrlFilter.activate();

    }



    public void test1 () throws Exception {
        XPath xPath = new XPath (XP01);
        assertEquals ("creator", xPath.getLastNode());
        assertEquals (XP01, xPath.getXpathString());

        assertEquals ("xdav_nonXML", xPath.getSchema());

        xPath.setContentQueryFilter (mockFilter);
        assertEquals ("/xdav_nonXML[@ino:id='18' or @ino:id='20' or @ino:id='17']/properties/meta/office:document-meta/office:meta/dc:creator",
                      xPath.getXpathString());


        xPath.setSortBy (S01);
        assertEquals ("/xdav_nonXML[@ino:id='18' or @ino:id='20' or @ino:id='17'] sortall (./properties/meta/office:document-meta/office:meta/dc:title ascending)/properties/meta/office:document-meta/office:meta/dc:creator",
                      xPath.getXpathString());

        assertEquals ("./properties/meta/office:document-meta/office:meta/dc:creator",
                      xPath.extractSortAll());


    }


}

