/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/jdomobjects/XDescriptorsGenerator.java,v 1.1 2004/03/25 16:18:14 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.jdomobjects;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.common.IDesc;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/**
 * Generates XDescriptors objects.
 *
 */
public class XDescriptorsGenerator {
    public static final int DOC = 0;
    public static final int NODE = 1;

    private XDescriptors descriptors;
    private final Document doc;

    /**
     * creates the Generator.
     *
     * @pre        (descriptors != null)
     * @post
     *
     * @param      mode can be either DOC or NODE.
     *
     */
    public XDescriptorsGenerator (int mode) throws Exception {

        switch (mode) {
            case DOC:
                doc = DescDoc.getDocDoc();
                break;
            case NODE:
                doc = DescDoc.getNodeDoc();
                break;
            default:
                throw new IllegalStateException ();
        }
    }

    /**
     * returns the XDescriptors object of this generator
     *
     * @pre        (descriptors != null)
     * @post
     *
     * @return     the XDescriptors object of this generator
     */
    public XDescriptors getDescriptors() {
        return XFactory.loadDescriptor(doc.getRootElement());
    }

    /**
     * returns an iterator of XDescriptors objects. The objects retrieved by the
     * iterator are clones of the generators XDescriptors object, which only differ
     * in the URI
     *
     * @param      n  number of objects, this iterator shall retrieve
     *
     * @return     iterator
     */
    public Iterator getIterator (int n) {
        return new DescriptorsIterator (doc, n);
    }


    public static void main (String [] args) throws Exception {
        XDescriptorsGenerator gen = new XDescriptorsGenerator (XDescriptorsGenerator.NODE);
        Iterator it = gen.getIterator (100);
        while (it.hasNext()) {
            XDescriptors desc = (XDescriptors)it.next();
            System.out.println(desc);
        }

    }

}


class DescriptorsIterator implements Iterator {
    private int number;
    private int counter;
    private Document original;
    private int state = IDesc.NO_STATE;


    DescriptorsIterator (Document original, int number, int state) {
        this (original, number);
        this.state = state;
    }

   DescriptorsIterator (Document original, int number) {
        this.original = original;
        this.number = number;
    }


    public boolean hasNext () {
        return (counter < number);
    }

    public void  remove () {
        throw new UnsupportedOperationException ();
    }

    public Object next () {
        Document doc = (Document) original.clone ();

        Element root = doc.getRootElement();
        Attribute uri = root.getAttribute ("uri");
        String sUri = uri.getValue();
        sUri = sUri + counter;
        uri.setValue (sUri);

        counter ++;
        return XFactory.loadDescriptor(doc.getRootElement());
    }
}




class DescDoc {

    static Document getDocDoc () throws JDOMException, IOException {
        InputStream in = new ByteArrayInputStream (docXml.getBytes());
        return new SAXBuilder().build (in);
    }

    static Document getNodeDoc () throws JDOMException, IOException {
        InputStream in = new ByteArrayInputStream (nodeXml.getBytes());
        return new SAXBuilder().build (in);
    }


    private static final String nodeXml =
        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>                                                                                                                       " +
        "<" + Configuration.get().taminoCollection + " uri=\"/wam\" dtdVersion=\"0.1\" aspects=\"5\">                              " +
        "<descriptorList />                                                                                                                                             " +
        "<locks />                                                                                                                                                      " +
        "<permissions>                                                                                                                                                  " +
        "<nodePermission objectUri=\"/wam\" subjectUri=\"/users/john\" actionUri=\"/actions/manage\" inheritance=\"true\" negative=\"false\" />                       " +
        "<nodePermission objectUri=\"/wam\" subjectUri=\"nobody\" actionUri=\"/actions/write\" inheritance=\"true\" negative=\"false\" />                             " +
        "<nodePermission objectUri=\"/wam\" subjectUri=\"nobody\" actionUri=\"/actions/read\" inheritance=\"true\" negative=\"false\" />                              " +
        "</permissions>                                                                                                                                                 " +
        "<descriptors>                                                                                                                                                  " +
        "<latestList />                                                                                                                                               " +
        "<branchList />                                                                                                                                               " +
        "<initialRevision revisionNumber=\"1.0\" />                                                                                                                   " +
        "</descriptors>                                                                                                                                                 " +
        "<objectNode kind=\"subject\">                                                                                                                                  " +
        "<parents />                                                                                                                                                " +
        "<children>                                                                                                                                                 " +
        "<childNode uriRef=\"/wam/New Folder\" />                                                                                                                   " +
        "<childNode uriRef=\"/wam/otto\" />                                                                                                                         " +
        "<childNode uriRef=\"/wam/fritz\" />                                                                                                                        " +
        "<childNode uriRef=\"/wam/franz\" />                                                                                                                        " +
        "<childNode uriRef=\"/wam/xxx\" />                                                                                                                          " +
        "</children>                                                                                                                                                  " +
        "<links />                                                                                                                                                    " +
        "</objectNode>                                                                                                                                                  " +
        "</" + Configuration.get().taminoCollection + ">                                                                                                                ";

    private static final String docXml =
        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>                                                                                                                       " +
        "<" + Configuration.get().taminoCollection + " uri=\"/wam/otto/validSlide.xml\" dtdVersion=\"0.1\" aspects=\"3\">          " +
        "  <descriptorList>                                                                                                                                               " +
        "    <descriptor revisionNumber=\"1.0\" branchName=\"main\">                                                                                                      " +
        "      <indexedPropertyList> </indexedPropertyList>                                                                                                               " +
        "      <propertyList>                                                                                                                                             " +
        "        <nodeProperty name=\"getetag\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"string\">948746834_48563_114</nodeProperty>                    " +
        "        <nodeProperty name=\"source\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"string\" />                                                     " +
        "        <nodeProperty name=\"xdavContentId\" namespace=\"DAV:\" type=\"\" protected=\"false\" datatype=\"string\">1@slide</nodeProperty>                         " +
        "        <nodeProperty name=\"getcontentlanguage\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"string\">en</nodeProperty>                          " +
        "        <nodeProperty name=\"getlastmodified\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"string\">Tue, 10 Apr 2001 11:20:25 GMT</nodeProperty>  " +
        "        <nodeProperty name=\"resourcetype\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"string\" />                                               " +
        "        <nodeProperty name=\"getcontentlength\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"long\">114</nodeProperty>                             " +
        "        <nodeProperty name=\"getcontenttype\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"string\">TEXT/PLAIN</nodeProperty>                      " +
        "        <nodeProperty name=\"creationdate\" namespace=\"DAV:\" type=\"\" protected=\"true\" datatype=\"string\">2001-04-10T11:20:25Z</nodeProperty>              " +
        "        <nodeProperty name=\"displayname\" namespace=\"DAV:\" type=\"\" protected=\"false\" datatype=\"string\">/wam/otto/validSlide.xml</nodeProperty>          " +
        "      </propertyList>                                                                                                                                            " +
        "      <labels />                                                                                                                                                 " +
        "    </descriptor>                                                                                                                                                " +
        "  </descriptorList>                                                                                                                                              " +
        "  <locks />                                                                                                                                                      " +
        "  <permissions />                                                                                                                                                " +
        "  <objectNode kind=\"subject\">                                                                                                                                  " +
        "    <parents  />                                                                                                                                                 " +
        "    <children />                                                                                                                                                 " +
        "    <links />                                                                                                                                                    " +
        "  </objectNode>                                                                                                                                                  " +
        "  <descriptors>                                                                                                                                                  " +
        "    <latestList>                                                                                                                                                 " +
        "      <latestRevision branchName=\"main\" revisionNumber=\"1.0\" />                                                                                              " +
        "    </latestList>                                                                                                                                                " +
        "    <branchList>                                                                                                                                                 " +
        "      <branch revisionNumber=\"1.0\" />                                                                                                                          " +
        "    </branchList>                                                                                                                                                " +
        "    <initialRevision revisionNumber=\"1.0\" />                                                                                                                   " +
        "  </descriptors>                                                                                                                                                 " +
        "</" + Configuration.get().taminoCollection + ">                                                                                                                                                        ";
}

