/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/jdomobjects/XDescriptorsTest.java,v 1.1 2004/03/25 16:18:14 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.jdomobjects;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.jdom.Namespace;

public class XDescriptorsTest extends TestCase {
    public XDescriptorsTest(String name) {
        super( name );
    }

    public void testEmpty() {
        final String URI = "myUri";
        XDescriptors x;

        x = new XDescriptors("foo", Namespace.NO_NAMESPACE, URI);
        assertEquals(URI, x.getUuri());
        x = XFactory.loadDescriptor(x.toXml().getRootElement());
        assertEquals(URI, x.getUuri());
        assertNull(x.getObjectNode(URI));
        assertNull(x.getUuriRevisionDescriptors());
        assertFalse(x.getRevisionDescriptorList().hasMoreElements());
        assertFalse(x.getLocks(URI).hasMoreElements());
    }

    public void testRevisionDescriptors() {
        final String uri = "myUri";
        XDescriptors x;

        x = new XDescriptors("foo", Namespace.NO_NAMESPACE, uri);
        x.setReadOnly(false);
        assertNull(x.getUuriRevisionDescriptors());
        assertFalse(x.removeRevisionDescriptors(new NodeRevisionDescriptors()));
        x.setRevisionDescriptors(new NodeRevisionDescriptors());
        assertNotNull(x.getUuriRevisionDescriptors());
        assertTrue(x.removeRevisionDescriptors(new NodeRevisionDescriptors()));
        assertNull(x.getUuriRevisionDescriptors());
    }

    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @param args   commandline options (not used)
     **/
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }


    public static Test suite() {
        return new TestSuite(XDescriptorsTest.class);
    }
}
