/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/jdomobjects/XNodeLockTest.java,v 1.1 2004/03/25 16:18:14 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.jdomobjects;

import java.io.IOException;
import java.text.ParseException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.util.JDom;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XNodeLockTest extends TestCase {
    public XNodeLockTest(String name) {
        super( name );
    }

    public void testNormal() throws JDOMException, ParseException, IOException {
        final String DATE = "20031214235959";
        NodeLock slide;

        slide = create("<nodeLock lockId='0' objectUri='1' subjectUri='2' typeUri='3' expirationDate='" + DATE + "' inheritance='true' exclusive='false' ownerInfo='4'/>");
        assertNull(slide.getObjectUri());
        assertEquals("2", slide.getSubjectUri());
        assertEquals("3", slide.getTypeUri());
        assertEquals("4", slide.getOwnerInfo());
        assertEquals(XJdom.DATE_FORMATTER.parse(DATE), slide.getExpirationDate());
        assertTrue(slide.isInheritable());
        assertFalse(slide.isExclusive());
    }

    private NodeLock create(String str) throws JDOMException, IOException {
        Element xml;
        NodeLock slide;

        xml = JDom.forString(str).getRootElement();
        // do toSlide/getElement roundtrip to test getElement as well
        slide = XNodeLock.toSlide(xml);
        xml = XNodeLock.toXml(slide);
        return XNodeLock.toSlide(xml);
    }

    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @param args   commandline options (not used)
     **/
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }


    public static Test suite() {
        return new TestSuite(XNodeLockTest.class);
    }
}
