/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/jdomobjects/XNodeRevisionDescriptorTest.java,v 1.1 2004/03/25 16:18:14 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:14 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.jdomobjects;

import java.io.IOException;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.util.JDom;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XNodeRevisionDescriptorTest extends TestCase {
    public XNodeRevisionDescriptorTest(String name) {
        super( name );
    }

    public void testEmpty() throws JDOMException {
        NodeRevisionDescriptor slide;

        slide = check(
            "<descriptor revisionNumber='1'>\n" +
            "  <labels/>\n" +
            "  <propertyList/>\n" +
            "</descriptor>");
        assertFalse(slide.enumerateLabels().hasMoreElements());
        assertFalse(slide.enumerateProperties().hasMoreElements());
    }

    public void testRevisionNumber() throws JDOMException {
        NodeRevisionDescriptor slide;

        slide = check(
            "<descriptor revisionNumber='42.17'>\n" +
            "  <labels/>\n" +
            "  <propertyList/>\n" +
            "</descriptor>");
        assertEquals(42, slide.getRevisionNumber().getMajor());
        assertEquals(17, slide.getRevisionNumber().getMinor());
    }

    public void testBranchExplcit() throws JDOMException {
        NodeRevisionDescriptor slide;

        slide = check(
            "<descriptor revisionNumber='1' branchName='foo'>\n" +
            "  <labels/>\n" +
            "  <propertyList/>\n" +
            "</descriptor>");
        assertEquals("foo", slide.getBranchName());
    }

    public void testBranchImplicit() throws JDOMException {
        NodeRevisionDescriptor slide;

        slide = check(
            "<descriptor revisionNumber='1'>\n" +
            "  <labels/>\n" +
            "  <propertyList/>\n" +
            "</descriptor>");
        assertEquals("main", slide.getBranchName());
    }

    public void testProperties() throws JDOMException {
        NodeRevisionDescriptor slide;
        Enumeration en;
        NodeProperty np;

        slide = check(
            "<descriptor revisionNumber='1'>\n" +
            "  <labels/>\n" +
            "  <propertyList>\n" +
            "    <nodeProperty type='foo' name='someName' datatype='string' protected='true'/>" +
            "  </propertyList>\n" +
            "</descriptor>");
        en = slide.enumerateProperties();
        np = (NodeProperty) en.nextElement();
        assertEquals("someName", np.getName());
        assertFalse(en.hasMoreElements());
    }

    public void testLabels() throws JDOMException {
        NodeRevisionDescriptor slide;
        Enumeration en;

        slide = check(
            "<descriptor revisionNumber='1'>\n" +
            "  <labels>\n" +
            "    <label>normal</label>\n" +
            "    <label/>" +
            "    <label></label>" +
            "  </labels>\n" +
            "  <propertyList/>\n" +
            "</descriptor>");
        en = slide.enumerateLabels();
        assertEquals("normal", en.nextElement());
        assertEquals("", en.nextElement());
        assertEquals("", en.nextElement());
        assertFalse(en.hasMoreElements());
    }

    public NodeRevisionDescriptor check(String str) throws JDOMException {
        Element xml;
        NodeRevisionDescriptor slide;

        try {
            xml = JDom.forString(str).getRootElement();
        } catch (IOException e) {
            fail(e.getMessage());
            return null; // dummy
        }
        // do toSlide/toXml roundtrip to test getElement as well
        slide = XNodeRevisionDescriptor.toSlide(xml);
        xml = XNodeRevisionDescriptor.toXml (slide, XGlobals.TSD4_SCHEMA_VERSION);
        return XNodeRevisionDescriptor.toSlide(xml);
    }

    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @param args   commandline options (not used)
     **/
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }


    public static Test suite() {
        return new TestSuite(XNodeRevisionDescriptorTest.class);
    }
}
