/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/jdomobjects/XStateMachineTest.java,v 1.3 2004/07/30 06:52:18 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:18 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.jdomobjects;

// import list
import org.apache.slide.store.tamino.common.IDesc;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;


/**
 ** JUnit Test for StateMachine.
 **
 **
 ** @author    wam@softwareag.com
 ** @version   1.0.0.0
 **/
public class XStateMachineTest extends TestCase {


    /**
     ** @param      name the given name
     **/
    public XStateMachineTest( String name) {
        super( name );

    }


    public void testStateMachine () {
        XStateMachine sm = new XStateMachine ();
        Assert.assertEquals("initDb", IDesc.CREATED_DELETED, sm.state());
        sm.set();
        Assert.assertEquals("set", IDesc.CREATED, sm.state());
        sm.set();
        Assert.assertEquals("set", IDesc.CREATED, sm.state());
        sm.remove();
        Assert.assertEquals("remove", IDesc.CREATED, sm.state());
        sm.remove();
        Assert.assertEquals("removeLast", IDesc.CREATED_DELETED, sm.state());
        sm.commit();
        Assert.assertEquals("commit", IDesc.NO_STATE, sm.state());
        sm = new XStateMachine();
        sm.set();
        Assert.assertEquals("commit", IDesc.CREATED, sm.state());
        sm.commit();
        Assert.assertEquals("commit", IDesc.UNCHANGED, sm.state());
        sm.set();
        Assert.assertEquals("set", IDesc.CHANGED, sm.state());
        sm.set();
        Assert.assertEquals("set", IDesc.CHANGED, sm.state());
        sm.remove();
        Assert.assertEquals("remove", IDesc.CHANGED, sm.state());
        sm.remove();
        sm.remove();
        Assert.assertEquals("removeLast", IDesc.DELETED, sm.state());
        sm.set();
        Assert.assertEquals("set", IDesc.CHANGED, sm.state());

        sm.remove();
        sm.commit();
        Assert.assertEquals("commit", IDesc.NO_STATE, sm.state());
    }

    public static Test suite () {
        // automatically call each method starting with 'test'.
        TestSuite suite = new TestSuite (XStateMachineTest.class);
        return suite;
    }
    
    public static void main(String[] args) {
        TestRunner.run( suite() );
    }
}
