/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/jdomobjects/XUuriTest.java,v 1.1 2004/03/25 16:18:15 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:15 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.jdomobjects;

import org.apache.slide.store.tamino.Configuration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class XUuriTest extends TestCase {
    public XUuriTest(String name) {
        super( name );
    }

    // TODO: test root uuri

    public void testSameStoreUuri() {
        String storeUri = "/" + Configuration.get().taminoCollection;
        assertEquals(XUuri.create(true, storeUri), XUuri.create(true, storeUri));
    }

    public void testSameNormalUuri() {
        String storeUri = "/" + Configuration.get().taminoCollection + "/foo";
        assertFalse(XUuri.create(true, storeUri).equals(XUuri.create(true, storeUri)));
    }

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }

    public static Test suite() {
        return new TestSuite(XUuriTest.class);
    }
}
