/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/store/FakeStore.java,v 1.1 2004/03/25 16:18:15 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:15 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.slide.store.AbstractStore;

/**
 * FakeStore.java
 */
public class FakeStore extends AbstractStore implements ISlideAccessor {
    private final String namespaceName;
    private final Map param;
    
    public FakeStore(String namespaceName) {
        this.namespaceName = namespaceName;
        this.param = new HashMap();
    }
    
    public String getParameter (String key) {
        return (String)param.get (key);
    }
    
    public void setParameter (String key, String value) {
        param.put (key, value);
    }
    
    public String getNamespaceName() {
        return namespaceName;
    }
}

