/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/store/monitoring/MonitorTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.store.monitoring;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 ** MonitorTest implements test cases for Monitor.
 **
 ** @author peter.nevermann@softwareag.com
 ** @version 0.0
 **/
public class MonitorTest extends TestCase {
    
    IMonitorable testMon = null;
    
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public MonitorTest( String testMethodName ) {
        super( testMethodName );
    }
    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }
    
    /**
     ** Return a TestSuite.
     **
     ** @pre   true
     ** @post  true
     **
     ** @return  TestSuite as a Test
     **/
    public static Test suite() {
        // automatically call each method starting with 'test'.
        TestSuite suite = new TestSuite(  MonitorTest.class );
        
        // additionally add subsuites here
        // suite.addTest( XXX.suite() );
        // suite.addTest( YYY.suite() );
        
        
        // return the this suite
        return suite;
    }
     
    /**
     ** Construct your fixtures for the test cases in MonitorTest.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void setUp() {
        System.out.println("\nCreating monitorables...");
        testMon = new TM_TOP();
    }
    
    /**
     ** Destruct your fixtures for the test cases in MonitorTest.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void tearDown() {
        System.out.println("\nDestructing monitorables...");
        Monitor.clear();
    }
        
    /**
     ** This test ...
     **
     ** @pre   true
     ** @post  true
     **/
    public void testPrintSnapshotXML() {
        printSnapshotXML( testMon );
        
        // implement your test here
        assertTrue( "Finnished", true );  // empty tests are regarded as todo
    }
    
    private void printSnapshotXML( IMonitorable testMon ) {
        String snapshotXML = null;
        try {
            snapshotXML = testMon.getMonitor().snapshotXML();
        }
        catch( java.io.IOException x ) { x.printStackTrace(); }
        
        System.out.println("\nMonitored: "+Monitor.uriFor(testMon, false));
        Iterator i = null;
        
        System.out.println(snapshotXML);
        
        if( !testMon.getMonChildren().isEmpty() ) {
            i = testMon.getMonChildren().iterator();
            while( i.hasNext() )
                printSnapshotXML( (IMonitorable)i.next() );
        }
    }
    
    /**
     ** Monitorable class.
     **/
    public class TM_A extends AbstractMonitorable {

        public TM_A( IMonitorable parent ) {
            this.monName = "A";
            this.monParent = parent;
            this.monitor = Monitor.getMonitor( this ); // this comes last!!

            MonitoredCounter c1 = monitor.getCounter( "CA1" );
            MonitoredCounter c2 = monitor.getCounter( "CA2" );
            MonitoredTimer testMon1   = monitor.getTimer( "TA1" );
            MonitoredTimer testMon2   = monitor.getTimer( "TA2" );
            c1.increment();
            c1.increment();
            c1.increment();
            c2.increment();
            c2.increment();
            c2.increment();
            c2.increment();
            c2.increment();
            Object timerId1 = testMon1.start();
            Object timerId2 = testMon2.start();
            try {Thread.sleep(300);} catch( InterruptedException x ) {}
            testMon2.stop(timerId2);
            try {Thread.sleep(200);} catch( InterruptedException x ) {}
            testMon1.stop(timerId1);
        }
    }
    
    /**
     ** Monitorable class.
     **/
    public class TM_B extends AbstractMonitorable {

        public TM_B( IMonitorable parent ) {
            this.monName = "B";
            this.monParent = parent;
            this.monitor = Monitor.getMonitor( this ); // this comes last!!
            
            MonitoredCounter c1 = monitor.getCounter( "CB1" );
            MonitoredCounter c2 = monitor.getCounter( "CB2" );
            MonitoredTimer testMon1   = monitor.getTimer( "TB1" );
            MonitoredTimer testMon2   = monitor.getTimer( "TB2" );
            c1.increment();
            c1.increment();
            c1.increment();
            c1.increment();
            c1.increment();
            c2.increment();
            c2.increment();
            c2.increment();
            Object timerId1 = testMon1.start();
            Object timerId2 = testMon2.start();
            try {Thread.sleep(300);} catch( InterruptedException x ) {}
            testMon1.stop(timerId1);
            try {Thread.sleep(200);} catch( InterruptedException x ) {}
            testMon2.stop(timerId2);
        }
    }
    
    /**
     ** Monitorable class.
     **/
    public class TM_TOP extends AbstractMonitorable {

        public TM_TOP() {
            this.monName = "TOP";
            AbstractMonitorable ch1 = new TM_A( this );
            AbstractMonitorable ch2 = new TM_B( this );
            this.monChildren.add( ch1 );
            this.monChildren.add( ch2 );
            this.monitor = Monitor.getMonitor( this ); // this comes last!!
        }
    }
}

