/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/repairer/DefaultNamingTest.java,v 1.1 2004/03/25 16:18:15 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:15 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer;


import org.apache.slide.store.tamino.tools.repairer.enabler.DefaultNaming;
import org.apache.slide.store.tamino.tools.repairer.enabler.Document;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DefaultNamingTest extends TestCase {
    public DefaultNamingTest(String name) {
        super( name );
    }
    
    public void test() throws Exception {
        DefaultNaming naming = new DefaultNaming(1);
        
        assertEquals("/mydoctype/folder1/docname.txt", naming.getName(new DumbResource()));
        assertEquals("/mydoctype/folder2/docname.txt", naming.getName(new DumbResource()));
    }

    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(DefaultNamingTest.class);
    }
}

class DumbResource implements Document {
    public long getLength() {
        return 0;
    }
    
    public String getTaminoId() {
        return "myId";
    }
    
    public String getDoctype() {
        return "mydoctype";
    }
    
    public String getMimeType() {
        return "txt";
    }
    
    public InputStream getContent() {
        return null;
    }
    
    public String getTaminoDocname() {
        return "docname";
    }
    
    public List getMimeExtensions() {
        List lst;
        
        lst = new ArrayList();
        lst.add("txt");
        return lst;
    }
}


