/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/repairer/EnablerTest.java,v 1.1 2004/03/25 16:18:15 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:15 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.tools.repairer.DocumentEnabler;
import org.apache.slide.store.tamino.tools.repairer.NamespaceConsistencyCheck;
import org.apache.slide.util.Misc;

public class EnablerTest extends TestCase {
    private RepairHelper impl;
    
    public EnablerTest (String name) {
        super (name);
    }
    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    public static void main( String[] args ) {
        //TestRunner.run( new RepairTest("testUniqueContentIdCheck") );
        TestRunner.run( EnablerTest.class );
    }
    
    /**
     ** Construct your fixtures for the test cases in CaseTemplate.
     **
     ** @pre   true
     ** @post  true
     **/
    protected void setUp() throws Exception {
        super.setUp();
        
        impl = new RepairHelper(Configuration.get().namespace);
        impl.wipeDatabase();
    }
    
    public void testMissingDescriptor() throws Exception {
        String uuri = impl.doCreate("/test/meta/test2.xml");
        impl.taminoClient.getDescriptorsAccessor().deleteByQuery(impl.taminoClient.getContentCollection() + "[@uri=\"" + uuri + "\"]");

        // TODO: doesn't call enabler
        impl.testRepairer(Misc.lst(DocumentEnabler.class),
                          Misc.lst(DocumentEnabler.class,
                          NamespaceConsistencyCheck.RemoveReference.class));
    }
    
    /**
     **/
    public void testenableNonXMLdocument() throws Exception {
        impl.taminoClient.insertText("TextDocument.txt", "This is only text.".getBytes());
        // TODO: doesn't call enabler
        impl.testRepairer(Misc.lst(DocumentEnabler.class),
                          Misc.lst(DocumentEnabler.class));
    }
}


