/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/repairer/MigrationTest.java,v 1.1 2004/03/25 16:18:15 juergen Exp $
 * $Revision: 1.1 $
 * $Date: 2004/03/25 16:18:15 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.slide.store.tamino.tools.repairer;

import com.softwareag.tamino.db.api.common.TException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.store.tamino.common.XGlobals;
import org.apache.slide.store.tamino.tools.collection.Collection;
import org.apache.slide.store.tamino.tools.collection.StoreDir;
import org.apache.slide.store.tamino.tools.repairer.ContentCheck;
import org.apache.slide.store.tamino.tools.repairer.DocumentEnabler;
import org.apache.slide.store.tamino.tools.repairer.MetadataVersionCheck;
import org.apache.slide.store.tamino.tools.repairer.NamespaceConsistencyCheck;
import org.apache.slide.util.Files;
import org.apache.slide.util.Misc;
import org.apache.slide.util.XException;

public class MigrationTest extends TestCase {
    private static final File BASE = new File("/home/mhm/src/testcases"); // TODO: configure
    
    public static void main( String[] args ) throws Exception {
        TestRunner.run( new MigrationTest("testMigrate") );
        //TestRunner.run( RepairTest.class );
        //save("testMigrate");
    }

    private static void save(String testName) throws Exception {
        StoreDir dir;
        
        dir = new StoreDir(new File(BASE, fixName(testName)),
                           Configuration.get().getTaminoDatabaseUrl(), Configuration.get().taminoCollection);
        dir.save();
    }
    
    private RepairHelper impl;
    
    public MigrationTest(String name) {
        super(name);
    }
    
    protected void setUp() throws Exception {
        super.setUp();
        
        StoreDir storeDir;
        
        storeDir = createStoreDir(getName());
        storeDir.load();
        impl = new RepairHelper(Configuration.get().namespace);
    }
    
    private static StoreDir createStoreDir(String testName) {
        try {
            return StoreDir.createExisting(new File(BASE, fixName(testName)),
                                           Configuration.get().getTaminoDatabaseUrl());
        } catch (IOException e) {
            fail(e.getMessage());
            return null; // dummy
        }
    }
    
    private static String fixName(String name) {
        if (name.startsWith("test")) {
            name = name.substring(4);
        } else {
            fail("invalid name: " + name);
        }
        return name.toLowerCase();
    }
    
    //--
    
    public void testMigrate() throws Exception {
        List lst;
        
        lst = new ArrayList();
        lst.add(MetadataVersionCheck.UpgradeMetadataSchema.class);
        for (int i = 0; i < 5; i++) { // 5 documents: 4 store roots and 1 true document
            lst.add(MetadataVersionCheck.UpgradeMetadata.class);
        }
        impl.testRepairer(lst);
    }
    
    /**
     * this test try to repair missing directory entries metadata.
     **/
    public void testInvalidDescriptor() throws Exception {
        impl.testRepairer(Misc.lst(ContentCheck.RemoveDescriptor.class),
                          Misc.lst(ContentCheck.RemoveDescriptor.class,
                                   NamespaceConsistencyCheck.RemoveReference.class),
                          // TODO: patch itself has to Create metadata -- wait for collection enabler
                          Misc.lst(DocumentEnabler.class)
                         );
    }
    
    /**
     * this test try to repair the metadata in case of a non-existing document.
     **/
    public void testnonExistingDocument() throws Exception {
        impl.testRepairer(Misc.lst(ContentCheck.RemoveDescriptor.class),
                          Misc.lst(ContentCheck.RemoveDescriptor.class, NamespaceConsistencyCheck.RemoveReference.class));
    }

    public static void save() throws IOException, TException, XException {
        final String URL  = "http://bolrep2.software-ag.de/tamino/mhm";
        final boolean load = true;
        File base;
        File content;
        File metadata;
        
        base = new File("/home/mhm/src/testcases/migrate");
        content = new File(base, "content");
        metadata = new File(base, "metadata");
        if (!load) {
            if (base.exists()) {
                Files.delete(base);
            }
            Files.mkdir(base);
        }
        run(metadata, URL, XGlobals.META_COLLECTION, load);
        run(content, URL, "mycoll", load);
        System.out.println("done");
    }
    
    public static void run(File dir, String url, String collection, boolean load)
        throws IOException, TException, XException {
        Collection ca;
        
        ca = new Collection(url, collection);
        if (load) {
            System.out.println("loading " + url + "/" + collection);
            ca.load(dir);
        } else {
            Files.mkdir(dir);
            System.out.println("saving " + url + "/" + collection);
            ca.save(dir);
        }
    }
    
    //--
    
}


