/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/ParameterTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class ParameterTest extends TestCase {
    private Parameters parms;
    private Parameter p1;
    private Parameter p2;
    
    public ParameterTest(String name) {
        super(name);
    }
    
    public void testString() {
        parms = new Parameters();
        p1 = new Parameter("foo", "dflt");
        p2 = new Parameter("foo", null);
        
        assertEquals("dflt", p1.getString(parms));
        assertNull(p2.getString(parms));
        p1.setString(parms, "bar");
        assertEquals("bar", p1.getString(parms));
        p2.setString(parms, "fff");
        assertEquals("fff", p2.getString(parms));
    }
    
    public void testBoolean() {
        parms = new Parameters();
        p1 = new Parameter("foo", "true");
        p2 = new Parameter("foo", null);
        
        assertTrue(p1.getBoolean(parms));
        assertFalse(p2.getBoolean(parms));
        p1.setBoolean(parms, false);
        assertFalse(p1.getBoolean(parms));
        p2.setBoolean(parms, true);
        assertTrue(p2.getBoolean(parms));
    }
    
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(ParameterTest.class);
    }
}

