/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/ParametersTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.slide.util.XException;
import org.jdom.Element;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class ParametersTest extends TestCase {
    private static final String FIRST = "first";
    private static final String SECOND = "second";
    private static final String ONE = "1";
    private static final String TWO = "2";
    
    private Parameters parms;
    
    public ParametersTest(String name) {
        super(name);
    }
    
    public void testEmpty() {
        parms = new Parameters();
        assertEquals(0, parms.size());
        assertNull(parms.get("noSuchParameter"));
    }
    
    public void testTwo() {
        parms = two();
        assertEquals(2, parms.size());
        assertEquals(ONE, parms.get(FIRST));
        assertEquals(TWO, parms.get(SECOND));
        parms.set(FIRST, "11");
        assertEquals(2, parms.size());
        assertEquals("11", parms.get(FIRST));
    }
    
    public void testGetDefault() {
        final String DFLT = "xy";
        parms = two();
        assertEquals(TWO, parms.get(SECOND, DFLT));
        assertNull(parms.get("third"));
        assertEquals(DFLT, parms.get("third", DFLT));
    }
    
    public void testClear() {
        parms = two();
        assertEquals(2, parms.size());
        parms.clear();
        assertEquals(0, parms.size());
        assertNull(parms.get(FIRST));
    }
    
    public void testSetAllNormal() {
        parms = new Parameters();
        parms.setAll(new Parameters());
        assertEquals(0, parms.size());
        parms.setAll(two());
        assertEquals(2, parms.size());
        parms.setAll(two());
        assertEquals(2, parms.size());
        assertEquals(ONE, parms.get(FIRST));
    }
    
    public void testSetAllExcludes() {
        Parameters excludes;
        
        parms = new Parameters();
        parms.setAll(two(), two());
        assertEquals(0, parms.size());
        
        excludes = new Parameters();
        excludes.set(SECOND, TWO);
        parms.setAll(two(), excludes);
        assertEquals(1, parms.size());
        assertEquals(ONE, parms.get(FIRST));
        assertNull(parms.get(SECOND));

        excludes = new Parameters();
        excludes.set(SECOND, "22");
        parms = new Parameters();
        parms.setAll(two(), excludes);
        assertEquals(2, parms.size());
        assertEquals(ONE, parms.get(FIRST));
        assertEquals(TWO, parms.get(SECOND));
    }
    
    public void testEqualsEmpty() {
        assertEquals(new Parameters(), new Parameters());
    }
    
    public void testEqualsTwo() {
        assertEquals(two(), two());
    }
    
    public void testNotEqualsValue() {
        parms = two();
        parms.set(FIRST, "xx");
        assertFalse(parms.equals(two()));
    }
    
    public void testNotEqualsMore() {
        parms = two();
        parms.set("x", "y");
        assertFalse(parms.equals(two()));
    }
    
    public void testXml() throws XException {
        Element root;
        
        root = new Element("foo");
        two().addXml(root);
        assertEquals(2, root.getContent().size());
        parms = Parameters.fromXml(root);
        assertEquals(2, parms.size());
        assertEquals(ONE, parms.get(FIRST));
        assertEquals(TWO, parms.get(SECOND));
    }
    
    public static void main( String[] args ) {
        TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(ParametersTest.class);
    }
    
    private Parameters two() {
        Parameters tmp;
        
        tmp = new Parameters();
        tmp.set(FIRST, ONE);
        tmp.set(SECOND, TWO);
        return tmp;
    }
}

