/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/XDomainFileHandlerTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.store.tamino.Configuration;
import org.apache.slide.util.XException;
import org.apache.slide.util.XUri;


/**
 ** Test for XDomainFileHandler.
 **
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XDomainFileHandlerTest extends TestCase {
    public XDomainFileHandlerTest( String testMethodName ) {
        super( testMethodName );
    }
    
    
    public void testNormal() throws XException {
        final String testcoll = Configuration.get().taminoCollection;
        XNamespace ns;
        XStoreGroup group;
        XDomainConfig globals;
        
        ns = Configuration.get().getNamespace();
        assertNotNull(ns);
        group = ns.getStoreGroup(testcoll);
        assertNotNull(group);
        
        assertNotNull(group.lookupStore(testcoll));
        assertNotNull(group.lookupStore("$deltav_history_" + testcoll));
        assertNotNull(group.lookupStore("$deltav_workspace_" + testcoll));
        assertNotNull(group.lookupStore("$deltav_workingresource_" + testcoll));
        
        globals = XDomainFileHandler.get().getDomain().getConfig();

        assertNotNull(group.lookupByScope(new XUri("/" + testcoll)));
        assertNotNull(group.lookupByScope(new XUri("/history/" + testcoll)));
        assertNotNull(group.lookupByScope(new XUri("/workspace/" + testcoll)));
        assertNotNull(group.lookupByScope(new XUri("/workingresource/" + testcoll)));
        
        assertEquals("/history/foo", globals.getScopePattern(XDomainConfig.HISTORY_SCOPE_PATTERN).resolve("foo"));
        assertEquals("/workspace/foo", globals.getScopePattern(XDomainConfig.WORKSPACE_SCOPE_PATTERN).resolve("foo"));
        assertEquals("/workingresource/foo", globals.getScopePattern(XDomainConfig.WORKINGRESOURCE_SCOPE_PATTERN).resolve("foo"));
    }

    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }
    
    public static Test suite() {
        return new TestSuite(  XDomainFileHandlerTest.class );
    }
}

