/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/XNamePatternTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import junit.framework.TestCase;
import org.apache.slide.util.Pattern;
import org.apache.slide.util.XUri;

/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XNamePatternTest extends TestCase {
    public XNamePatternTest(String name) {
        super(name);
    }

    private XNamePattern np;
    
    public void test() {
        np = new XNamePattern("pre", "post", null, new Pattern("/${store}"));
        assertEquals(null, np.matches("name", new XUri("mycoll")));
        assertEquals("mycoll", np.matches("premycollpost", new XUri("mycoll")));
    }
    public void test2() {
        np = new XNamePattern("$txfile_", "", null, new Pattern("/${store}"));
        assertEquals("txfile", np.matches("$txfile_txfile", new XUri("txfile")));  // TODO: why initial /
    }
}

