/*
 * $Header: /home/cvspublic/jakarta-slide/proposals/tamino/testsuite/junit/store/org/apache/slide/store/tamino/tools/stores/XNamespaceTest.java,v 1.3 2004/07/30 06:52:19 ozeigermann Exp $
 * $Revision: 1.3 $
 * $Date: 2004/07/30 06:52:19 $
 *
 * ====================================================================
 *
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.slide.store.tamino.tools.stores;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.slide.util.XException;
import org.jdom.Element;


/**
 ** @author    michael.hartmeier@softwareag.com
 ** @version   $Revision: 1.3 $
 **/
public class XNamespaceTest extends TestCase {
    private static final XDomainConfig CONF = XDomainConfig.createDefault();
    private static final XStoreGroupTypeList GT = CONF.createTypes();
    /**
     ** Construct a test case with the given test method name.
     **
     ** @pre   testMethodName != null
     ** @post  true
     **
     ** @param testMethodName   name of the test method that should be invoked
     **/
    public XNamespaceTest(String testMethodName) {
        super( testMethodName );
    }
    
    public void testEmpty() throws XException {
        check(new XNamespace("foo"));
    }
    
    public void testConfig() throws XException {
        XNamespace ns;
        
        ns = new XNamespace("foo");
        check(ns);
    }

    public void testOne() throws XException {
        XNamespace ns;
        
        ns = new XNamespace("foo");
        ns.addStoreGroup(GT.userTamino.create("mycoll"));
        check(ns);
    }
    
    public void testTwo() throws XException {
        XNamespace ns;
        
        ns = new XNamespace("foo");
        ns.addStoreGroup(GT.userTamino.create("first"));
        ns.addStoreGroup(GT.secUrm.create("second"));
        check(ns);
    }
    
    public void check(XNamespace orig) throws XException {
        XNamespace cloned;
        Element xml;
        
        xml = orig.toXml();
        cloned = XNamespace.fromXml(GT, xml);
        assertEquals(orig.name, cloned.name);
        assertEquals(orig.getPublicStoreGroups().size(), cloned.getPublicStoreGroups().size());
        assertEquals(orig.getConfig(), cloned.getConfig());
    }
    
    /**
     ** Start precisely this test suite with the commandline interface.
     **
     ** @pre   true
     ** @post  true
     **
     ** @param args   commandline options (none are evaluated)
     **/
    public static void main( String[] args ) {
        junit.textui.TestRunner.run( suite() );
    }
    
    
    public static Test suite() {
        return new TestSuite(XNamespaceTest.class);
    }
}

